<?php
/**
 * The template for displaying Search Results pages.
 */

get_header(); ?>

	<section id="primary" class="content-area boxed">
		<h3 class="section-title">
			<span>
				<?php
				/* translators: %s: search keyword */
				printf( esc_html__( 'Search Results for: %s', 'mallow' ), '<span>' . get_search_query() . '</span>' ); 
				?>
			</span>
		</h3>
		
		<div id="content" class="site-content group" role="main">

			<?php if ( have_posts() ) : ?>
				
				<?php while ( have_posts() ) : the_post(); ?>

					<?php get_template_part( 'template-parts/content' ); ?>

				<?php endwhile; ?>

				<?php mallow_loadmore(); ?>
			<?php else : ?>

				<?php get_template_part( 'template-parts/no-results', 'search' ); ?>

			<?php endif; ?>

		</div>
	</section>

<?php 

get_sidebar(); 
get_footer();
