<?php
/**
 * Template Name: Fullwidth
 *
 * The Template for displaying fullwidth page.
 */

// Following filter override Global Content Width for the page
add_filter( 'mallow_page_full_width', '__return_true' );

get_header(); ?>

	<div id="primary" class="content-area boxed">
		<?php mallow_breadcrumb(); ?>

		<div id="content" class="site-content" role="main">

			<?php while ( have_posts() ) : the_post(); ?>
				<?php get_template_part( 'template-parts/content', 'page' ); ?>

				<?php
				// If comments are open or we have at least one comment, load up the comment template
				if ( comments_open() || get_comments_number() ) {
					comments_template( '', true );
				}
				?>

			<?php endwhile; // end of the loop. ?>

		</div>
	</div

<?php

get_footer();