/* global _mallowJS */

(function ($) {

    $(document).ready(function () {

        $('#primary').fitVids();
        $('#secondary').fitVids();

        $('.tabs').fwTabs();

        function fixSidebarTop() {
            $('.logo').css('marginTop', '30px').css('marginBottom', '30px');

            if ($(window).width() > 720) {

                if ($('.logo').height() > $('#sidebar-top').height()) {
                    $('#sidebar-top').css('marginTop', ( ( ($('.logo').height() ) / 2) - ($('#sidebar-top').height() / 2) ) + 30 + 'px');
                } else {
                    $('.logo').css('marginTop', ( ( ($('#sidebar-top').height() ) / 2) - ($('.logo').height() / 2) ) + 30 + 'px');
                }
            } else {
                $('#sidebar-top').css('marginTop', '30px').css('marginBottom', '0');
                $('.logo').css('marginTop', '30px').css('marginBottom', '30px');
            }
        }

        $('.load-more a').on('click', function (e) {
            e.preventDefault();
            $(this).addClass('loading').text(_mallowJS.button_loading);
            $.ajax({
                type: "GET",
                url: $(this).attr('href') + '#content',
                dataType: "html",
                success: function (out) {
                    result = $(out).find('#content .post');
                    nextlink = $(out).find('.load-more a').attr('href');

                    $('.load-more').before(result.fadeIn(300));
                    $('.load-more a').removeClass('loading').text(_mallowJS.button_load_more);
                    if (nextlink != undefined) {
                        $('.load-more a').attr('href', nextlink);
                    } else {
                        $('.load-more').remove();
                    }
                }
            });
        });

        $('.submenu-button').live('click', function () {
            $(this).nextAll('ul').slideToggle(100);
            $(this).toggleClass('expand');
            return false;
        });

        $(window).scroll();

        // Mobile Menu
        var menu_primary = $('.primary-navigation .menu'),
            menu_secondary = $('.secondary-navigation .menu'),
            html_primary = '',
            html_secondary = '';

        if (menu_primary.length) {
            html_primary = menu_primary.html();
        }
        if (menu_secondary.length) {
            html_secondary = menu_secondary.html();
        }

        if (menu_primary.length || menu_secondary.length) {
            $('#masthead').prepend('<div id="dl-menu" class="dl-menuwrapper"><a class="submenu-button" href="#">F</a><ul class="dl-menu"></ul></div>');
            $('.dl-menu').html(html_primary + html_secondary);
            $('.dl-menu li').has('ul').prepend('<a class="submenu-button" href="#">&nbsp;</a>');
            $('#dl-menu ul').hide();
        }

    });

})(jQuery);

(function ($) {

    $.fn.fwTabs = function (options) {
        var settings = $.extend({}, $.fn.fwTabs.defaults, options);
        var active = 0;
        var tabs = $(this);

        $('.nav-tab li', tabs).click(function () {
            idx = $(this).index();
            if (idx == $('.nav-tab li.tab-active', tabs).index()) return false;
            startTab(tabs, idx);
            return false;
        });

        function startTab(tabs, idx) {
            $('.active', tabs).fadeOut().removeClass('active').addClass('hide');
            $('.tab-content', tabs).eq(idx).removeClass('hide').addClass('active').fadeIn();
            $('li.tab-active', tabs).removeClass('tab-active');
            $('.nav-tab li', tabs).eq(idx).addClass('tab-active');
        }
    };

})(jQuery);