<?php

class Mallow_Widget_Recent_Posts extends WP_Widget {

	function __construct() {
		parent::__construct( 'mallow_recent_posts', esc_html__( 'Mallow - Recent Posts', 'mallow' ), array(
			'classname'   => 'widget_posts_wrap',
			'description' => esc_html__( 'Mallow - Recent Posts', 'mallow' )
		) );
	}

	function widget( $args, $instance ) {
		$default      = array(
			'title'    => esc_html__( 'Recent Posts', 'mallow' ),
			'cats'     => '',
			'cat'      => '',
			'quantity' => 5,
			'exclude'  => '',
			'order'    => 'date',
			'display'  => 'type-3',
			'excerpt'  => 'display',
			'not_in'   => ''
		);
		$instance     = wp_parse_args( $instance, $default );
		$widget_title = apply_filters( 'widget_title', $instance['title'] );
		$cats         = $instance['cats'];
		$cat          = $instance['cat'];
		$quantity     = $instance['quantity'];
		$order        = $instance['order'];
		$display      = 'type-3';
		$not_in       = $instance['not_in'];

		echo $args['before_widget'];
		?>
		<?php if ( ! empty( $instance['title'] ) && $cat == "multiple_cat" ) {
			echo $args['before_title'] . $widget_title . $args['after_title'];
		} ?>
		<?php if ( $cat != 'multiple_cat' ) {
			echo $args['before_title'] . apply_filters( 'widget_title', get_cat_name( $cat ) ) . $args['after_title'];
		} ?>
		<div class="widget_posts">
			<?php
			if ( $cat == "multiple_cat" ) {
				$category = $cats;
			} else {
				$category = $cat;
			}
			$r = new WP_Query( array(
				'showposts'           => $quantity,
				'cat'                 => $category,
				'orderby'             => $order,
				'post_status'         => 'publish',
				'post__not_in'        => $not_in,
				'ignore_sticky_posts' => 1,
			) );
			$i = 0;
			while ( $r->have_posts() ) : $r->the_post(); ?>
				<article>
					<header class="clearfix">
						<?php if ( has_post_thumbnail() ) { ?>
							<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"
							   class="home-thumb"><?php the_post_thumbnail( 'thumbnail' ); ?></a>
						<?php } ?>
						<h4 class="entry-title no-heading-style"><a href="<?php the_permalink() ?>" rel="bookmark"
						                                            title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
						</h4>
						<div class="entry-meta">
							<time
								datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php the_time( get_option( 'date_format' ) ); ?></time>
							<span><?php comments_popup_link(
									esc_html__( 'No comment', 'mallow' ),
									esc_html__( '1 Comment', 'mallow' ),
									esc_html__( '% Comments', 'mallow' )
								); ?></span>
						</div>
					</header>
				</article>
				<?php

				$i ++;

			endwhile;

			wp_reset_postdata(); ?>
		</div>
		<div class="clear"><!-- --></div>
		<?php
		echo $args['after_widget'];
	}

	function update( $new_instance, $old_instance ) {
		$instance             = $old_instance;
		$instance['title']    = sanitize_text_field( $new_instance['title'] );
		$instance['cats']     = sanitize_text_field( $new_instance['cats'] );
		$instance['cat']      = $new_instance['cat'];
		$instance['quantity'] = absint( $new_instance['quantity'] );
		$instance['order']    = $new_instance['order'];
		$instance['display']  = $new_instance['display'];

		$default = array(
			'title'    => esc_html__( 'Recent Posts', 'mallow' ),
			'cats'     => '',
			'cat'      => '',
			'quantity' => 1,
			'exclude'  => '',
			'order'    => 'date',
			'display'  => 'type-3'
		);

		$instance = wp_parse_args( $instance, $default );

		return $instance;
	}

	public function form( $instance ) {
		$default      = array(
			'title'    => esc_html__( 'Recent Posts', 'mallow' ),
			'cats'     => '',
			'cat'      => '',
			'quantity' => 5,
			'exclude'  => '',
			'order'    => 'date',
			'display'  => 'type-3'
		);
		$instance     = wp_parse_args( $instance, $default );
		$widget_title = $instance['title'];
		$cats         = $instance['cats'];
		$cat          = $instance['cat'];
		$quantity     = $instance['quantity'];
		$order        = $instance['order'];
		?>

		<p>
			<?php esc_html_e( 'Widget title (Will automaticly use category name when select single category):', 'mallow' ); ?>
			<input class="widefat" type="text" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
			       value="<?php echo esc_attr( $widget_title ); ?>"/>
		</p>
		<p>
			<?php esc_html_e( 'Category:', 'mallow' ); ?>
			<select name="<?php echo esc_attr( $this->get_field_name( 'cat' ) ); ?>">
				<option value="multiple_cat" <?php selected( "multiple_cat", $cat, true ); ?> ><?php esc_html_e( 'Multiple Categories', 'mallow' ); ?></option>
				<?php
				$of_categories_obj = get_categories( 'hide_empty=0' );
				foreach ( $of_categories_obj as $of_cat ) {
					?>
					<option <?php selected( $of_cat->cat_ID, $cat, true ); ?> value="<?php echo intval( $of_cat->cat_ID ); ?>" ><?php echo $of_cat->cat_name; ?></option>
					<?php
				}
				?>
			</select>
		</p>
		<p>
			<?php esc_html_e( 'Enter ID of categories e.g. 1,2,3,4. Leave it blank to pull all categories (if multiple category choosed).', 'mallow' ); ?>
			<input class="widefat" type="text" name="<?php echo esc_attr( $this->get_field_name( 'cats' ) ); ?>"
			       value="<?php echo esc_attr( $cats ); ?>"/>
		</p>
		<p>
			<?php esc_html_e( 'Posts:', 'mallow' ); ?>
			<select name="<?php echo esc_attr( $this->get_field_name( 'quantity' ) ); ?>">
				<?php for ( $i = 1 ; $i <= 15; $i++ ) { ?>
					<option	value="<?php echo $i ?>" <?php selected( $i, $quantity, true ); ?> ><?php echo $i; ?></option>
				<?php } ?>
			</select>
		</p>
		<p>
			<?php esc_html_e( 'Order posts by:', 'mallow' ); ?>
			<select name="<?php echo esc_attr( $this->get_field_name( 'order' ) ); ?>">
				<option
					value="date" <?php selected( $order, "date", true ); ?> ><?php esc_html_e( 'date', 'mallow' ); ?></option>
				<option
					value="rand" <?php selected( $order, "rand", true ); ?> ><?php esc_html_e( 'random', 'mallow' ); ?></option>
				<option
					value="comment_count" <?php selected( $order, "comment_count", true ); ?> ><?php esc_html_e( 'popular', 'mallow' ); ?></option>
			</select>
		</p>

		<?php
	}

}
