<?php

class Mallow_Widget_Recent_Comments extends WP_Widget {

	function __construct() {
		parent::__construct( 'mallow_recent_comments', esc_html__( 'Mallow - Recent Comments', 'mallow' ), array(
			'classname'   => 'widget_comments_wrap',
			'description' => esc_html__( 'Mallow - Recent Comments', 'mallow' ),
		) );
	}

	function widget( $args, $instance ) {
		$default      = array(
			'title'    => esc_html__( 'Latest Comments', 'mallow' ),
			'quantity' => '5'
		);
		$instance     = wp_parse_args( $instance, $default );
		$widget_title = apply_filters( 'widget_title', $instance['title'] );
		$quantity     = $instance['quantity'];

		echo $args['before_widget'];
		?>
		<?php if ( ! empty( $instance['title'] ) ) {
			echo $args['before_title'] . $widget_title . $args['after_title'];
		} ?>
		<div class="widget_posts">
			<?php
			$recent_comments = get_comments( array(
				'number' => $quantity,
				'status' => 'approve'
			) );

			foreach ( $recent_comments as $comment ) {
				?>
				<article>
					<header class="clearfix">
						<a href="<?php echo esc_url( get_comment_link( $comment ) ) ?>"
						   class="home-thumb"><?php echo get_avatar( $comment->comment_author_email, 60 ); ?></a>
						<h4 class="no-heading-style entry-title"><a
								href="<?php echo esc_url( get_comment_link( $comment ) ) ?>"><?php echo wp_trim_words( get_comment_excerpt( $comment->comment_ID ), 10 ); ?></a>
						</h4>
						<div class="entry-meta"> <?php esc_html_e( 'By', 'mallow' ); ?> <a
								href="<?php echo esc_url( get_comment_link( $comment ) ) ?>"
								class="comment_link"><?php echo esc_html( $comment->comment_author ); ?></a></div>
					</header>
				</article>
				<?php
			}
			?>
		</div>
		<?php
		echo $args['after_widget'];
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		$instance['title']    = sanitize_text_field( $new_instance['title'] );
		$instance['quantity'] = absint( $new_instance['quantity'] );

		return $instance;
	}

	public function form( $instance ) {
		$default      = array(
			'title'    => esc_html__( 'Latest Comments', 'mallow' ),
			'quantity' => '5'
		);
		$instance     = wp_parse_args( $instance, $default );
		$widget_title = $instance['title'];
		$quantity     = $instance['quantity'];
		?>
		<p>
			<?php esc_html_e( 'Widget title:', 'mallow' ); ?>
			<input class="widefat" type="text" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>"
			       value="<?php echo esc_attr( $widget_title ); ?>"/>
		</p>
		<p>
			<?php esc_html_e( 'Posts', 'mallow' ); ?>
			<input class="widefat" type="text" name="<?php echo esc_attr( $this->get_field_name( 'quantity' ) ); ?>"
			       value="<?php echo esc_attr( $quantity ); ?>"/>
		</p>
		<?php
	}

}
