<?php
/**
 * Custom template tags for this theme.
 */

if ( ! function_exists( 'mallow_comment' ) ) :
	/**
	 * Template for comments and pingbacks.
	 *
	 * Used as a callback by wp_list_comments() for displaying the comments.
	 */
	function mallow_comment( $comment, $args, $depth ) {
		switch ( $comment->comment_type ) :
			case 'pingback' :
			case 'trackback' :
				?>
				<li class="post pingback">
				<p><?php esc_html_e( 'Pingback:', 'mallow' ); ?><?php comment_author_link(); ?><?php edit_comment_link( esc_html__( '(Edit)', 'mallow' ), ' ' ); ?></p>
				<?php
				break;
			default :
				?>
				<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
				<article id="comment-<?php comment_ID(); ?>" class="comment">
					<footer>
						<div class="comment-author vcard">
							<?php echo get_avatar( $comment, 40 ); ?>
							<cite class="fn"><?php echo get_comment_author_link(); ?></cite>
							<span class="says"><?php esc_html_e(' says: ', 'mallow'); ?></span>
						</div>
						<?php if ( $comment->comment_approved == '0' ) : ?>
							<em><?php esc_html_e( 'Your comment is awaiting moderation.', 'mallow' ); ?></em>
							<br/>
						<?php endif; ?>

						<div class="comment-meta commentmetadata">
							<a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
								<time datetime="<?php comment_time( 'c' ); ?>">
									<?php
									/* translators: 1: date, 2: time */
									printf( esc_html__( '%1$s at %2$s', 'mallow' ), get_comment_date(), get_comment_time() ); ?></time>
							</a>,
							<?php comment_reply_link( array_merge( $args, array(
								'depth'     => $depth,
								'max_depth' => $args['max_depth']
							) ) ); ?>

							<?php edit_comment_link( esc_html__( '(Edit)', 'mallow' ), ' ' );
							?>
						</div>
					</footer>

					<div class="comment-content"><?php comment_text(); ?></div>
				</article>
				<?php

				break;
		endswitch;
	}

endif;


if ( ! function_exists( 'mallow_posted_on' ) ) :
	/**
	 * Prints HTML with meta information for the current post-date/time and author.
	 */
	function mallow_posted_on() {
		printf( '<time class="entry-date" datetime="%1$s">%2$s</time>',
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() )
		);
	}

endif;


/**
 * Returns true if a blog has more than 1 category
 */
function mallow_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'mallow_the_cool_cats' ) ) ) {
		// Create an array of all the categories that are attached to posts
		$all_the_cool_cats = get_categories( array(
			'hide_empty' => 1,
		) );

		// Count the number of categories that are attached to the posts
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'mallow_the_cool_cats', $all_the_cool_cats );
	}

	if ( '1' != $all_the_cool_cats ) {
		// This blog has more than 1 category so mallow_categorized_blog should return true
		return true;
	} else {
		// This blog has only 1 category so mallow_categorized_blog should return false
		return false;
	}
}


/**
 * Flush out the transients used in mallow_categorized_blog
 */
function mallow_category_transient_flusher() {
	// Like, beat it. Dig?
	delete_transient( 'mallow_the_cool_cats' );
}

add_action( 'edit_category', 'mallow_category_transient_flusher' );
add_action( 'save_post', 'mallow_category_transient_flusher' );


/**
 * Displays the Site Brand.
 */
function mallow_site_brand() {
	if ( has_custom_logo() ) :

		the_custom_logo();

	else : ?>
		<h2 class="site-title h1"><a href="<?php echo esc_url( home_url( '/' ) ); ?>"
		                             title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"
		                             rel="home"><?php bloginfo( 'name' ); ?></a></h2>

		<?php $description = get_bloginfo( 'description', 'display' );

		if ( $description || is_customize_preview() ) : ?>
			<p class="site-description"><?php echo $description; ?></p>
		<?php endif;
	endif;
}


/**
 * Breadcrumbs
 */
function mallow_breadcrumb() {
	if ( ! is_front_page() ) {
		echo '<div id="breadcrumbs"> <a href="' . esc_url( home_url() ) . '">' . esc_html__( 'Home', 'mallow' ) . '</a> ';
	}

	if ( ( is_category() || is_single() ) && ! is_attachment() ) {
		$category = get_the_category();

		if ( count( $category ) > 0 ) {
			$ID = $category[0]->cat_ID;
			if ( $ID ) {
				echo get_category_parents( $ID, true, ' ', false );
			}
		}
	}

	if ( ! is_front_page() && ( is_single() || is_page() ) ) {
		the_title();
	}
	if ( is_tag() ) {
		/* translators: %s: tag name */
		printf( esc_html__( 'Tag: %s', 'mallow' ), single_tag_title( '', false ) );
	}
	if ( is_404() ) {
		esc_html_e( '404 - Page not Found', 'mallow' );
	}
	if ( is_search() ) {
		esc_html_e( 'Search', 'mallow' );
	}
	if ( is_year() ) {
		echo get_the_time( 'Y' );
	}
	if ( is_month() ) {
		echo get_the_time( 'F Y' );
	}
	if ( is_author() ) {
		/* translators: %s: Author name */
		printf( esc_html__( 'Posts by %s', 'mallow' ), get_the_author() );
	}

	if ( ! is_front_page() ) {
		echo "</div>";
	}
}


/**
 * Ajax load more tag
 */
function mallow_loadmore() {
	global $wp_query;

	$currpage  = get_query_var( 'paged' );
	$max_pages = $wp_query->max_num_pages;

	if ( ( $max_pages > $currpage ) && ( $max_pages > 1 ) ) {
		echo '<nav class="page-navigation load-more">';
		next_posts_link( esc_html__( 'Load More', 'mallow' ) );
		echo '</nav>';
	}
}
