<?php
/**
 * Custom functions that act independently of the theme templates
 */


/**
 * Adds custom classes to the array of body classes.
 */
function mallow_body_classes( $classes ) {

	if ( apply_filters( 'mallow_page_full_width', false ) ) {
		$classes[] = 'full-width';
	}

	// Adds a class of group-blog to blogs with more than 1 published author
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	if ( ! is_singular() && ! is_404() && ! in_array( 'search-no-results', $classes ) ) {
		$classes[] = apply_filters( 'mallow_loop_layout', 'one-column' );
	}

	return $classes;
}

add_filter( 'body_class', 'mallow_body_classes' );


/**
 * Set the excerpt length.
 */
function mallow_excerpt_length( $length ) {
	if ( ! is_admin() )
		return 20;
	else
		return $length;
}

add_filter( 'excerpt_length', 'mallow_excerpt_length', 999 );


/**
 * Fix the excerpt more text
 */
function mallow_excerpt_more( $more ) {
	return '...';
}

add_filter( 'excerpt_more', 'mallow_excerpt_more' );
