<?php
/**
 * Theme Dashboard Page
 */

/**
 * Add Theme Dashboard Page to the Appearance menu
 */
function mallow_theme_dashboard_menu() {

	add_theme_page(
		/* translators: %s. Current theme name */
		sprintf( esc_html__( '%s Theme Dashboard', 'mallow' ), wp_get_theme()->get( 'Name' ) ),
		/* translators: %s. Current theme name */
		sprintf( esc_html__( '%s Theme', 'mallow' ), wp_get_theme()->get( 'Name' ) ),
		'edit_theme_options',
		'mallow',
		'mallow_theme_dashboard_page'
	);

}

add_action( 'admin_menu', 'mallow_theme_dashboard_menu' );


/**
 * Add admin notice when the theme activated, just show one time
 */
function mallow_one_activation_admin_notice(){
	global $pagenow;

	if ( is_admin() && ('themes.php' == $pagenow) && isset( $_GET['activated'] ) ) {
		add_action( 'admin_notices', 'mallow_admin_notice' );
	}
}

add_action( 'load-themes.php',  'mallow_one_activation_admin_notice'  );

function mallow_admin_notice() {
	?>
	<div class="updated notice is-dismissible">
		<p><?php printf(
				/* translators: 1. Current theme name 2. Link to welcome page */
				esc_html__( 'Welcome! Thank you for choosing %1$s! To fully take advantage of the best our theme can offer please make sure you visit our %2$s', 'mallow' ),
				wp_get_theme()->get( 'Name' ),
				'<a href="'. esc_url( admin_url( 'themes.php?page=mallow' ) ) .'">'. esc_html__( 'Welcome page', 'mallow' ) .'</a>'
			); ?></p>
	</div>
	<?php
}


/**
 * Enqueue CSS for Dashboard Page only
 */
function mallow_theme_dashboard_enqueue( $hook ) {

	if ( $hook === 'appearance_page_mallow'  ) {
		wp_enqueue_style( 'mallow-dashboard-css', get_template_directory_uri() . '/css/dashboard.css' );
	}

}

add_action( 'admin_enqueue_scripts', 'mallow_theme_dashboard_enqueue' );


/**
 * Display the Dashboard Page
 */
function mallow_theme_dashboard_page() {

	$tab = null;

	if ( isset( $_GET['tab'] ) ) {
		$tab = wp_unslash($_GET['tab']);
	}
	?>
	<div class="wrap about-wrap theme-dashboard">
		<h1>
			<?php 
			/* translators: 1. Current theme name 2. Theme version */
			printf( esc_html__( 'Welcome to %1$s v%2$s', 'mallow' ), wp_get_theme()->get( 'Name' ), wp_get_theme()->get( 'Version' ) );
			?>
		</h1>
		<div class="about-text"><?php esc_html_e( 'Mallow is a simple blogging and magazine style WordPress theme, perfect for food bloggers, writers, authors, travel bloggers, or any type of blog.', 'mallow' ) ?></div>

		<a target="_blank"
		   href="<?php echo esc_url( 'https://fancythemes.com/?utm_source=theme_dashboard_page&utm_medium=badge_link&utm_campaign=theme_admin' ); ?>"
		   class="wp-badge fancythemes"><span><?php esc_html_e( 'FancyThemes', 'mallow' ); ?></span></a>

		<h2 class="nav-tab-wrapper">
			<a href="<?php echo esc_url( admin_url( 'themes.php?page=mallow' ) ) ?>" class="nav-tab<?php echo is_null( $tab ) ? ' nav-tab-active' : ''; ?>"><?php echo wp_get_theme()->get( 'Name' ); ?></a>
			<?php do_action( 'mallow_theme_dashboard_tabs' ); ?>
		</h2>

		<?php if ( is_null( $tab ) ) : ?>
			<div class="theme-tab-content">
				<div class="theme-content clearfix">
					<div class="theme-content-left">
						<div class="group">
							<h3><?php esc_html_e( 'Theme Customizer', 'mallow' ); ?></h3>
							<p class="about">
								<?php
								/* translators: %s Current theme name */
								printf( esc_html__( '%s utilises the Theme Customizer for all theme settings. Click "Live Customize" to customize your site for your needs.', 'mallow' ), wp_get_theme()->get( 'Name' ) );
								 ?>
							</p>
							<p><a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>"
							      class="button button-primary"><?php esc_html_e( 'Live Customize', 'mallow' ); ?></a></p>
						</div>

						<div class="group">
							<h3><?php esc_html_e( 'Theme Documentation', 'mallow' ); ?></h3>
							<p class="about">
								<?php
								/* translators: %s Current theme name */
								printf( esc_html__( 'Need any help to setup and configure %s? Please have a look at our documentations instructions.', 'mallow' ), wp_get_theme()->get( 'Name' ) );
								?>
							</p>
							<p><a href="http://docs.fancythemes.com" target="_blank"
							      class="button button-secondary"><?php esc_html_e( 'Online Documentation', 'mallow' ); ?></a></p>
						</div>

						<div class="group">
							<h3>
								<?php
								/* translators: %s Current theme name */
								printf( esc_html__( '%s Pro & Priority Support', 'mallow' ), wp_get_theme()->get( 'Name' ) );
								?>
							</h3>
							<p class="about">
								<?php 
								/* translators: %s Current theme name */
								printf( esc_html__( 'We have curated amazing features such as Advanced Color Options, Typography Settings, Featured Carousel, and more into %s Pro version, which also includes priority support.', 'mallow' ), wp_get_theme()->get( 'Name' ) );
								?>
							</p>
							<p><a href="https://fancythemes.com/themes/mallow/" target="_blank"
							      class="button button-secondary">
								  <?php
								  /* translators: %s Current theme name */
								  printf( esc_html__( 'Upgrade to %s Pro', 'mallow' ), wp_get_theme()->get( 'Name' ) );
								  ?>
							</a></p>
						</div>
					</div>

					<div class="theme-content-right">
						<img src="<?php echo esc_url( get_template_directory_uri() .'/screenshot.png' ); ?>" alt="<?php esc_attr( 'Theme Screenshot', 'mallow' ); ?>"/>
					</div>
				</div>
			</div>
		<?php endif; ?>

		<?php do_action( 'mallow_theme_dashboard_tab_content' ); ?>
	</div>
	<?php
}
