<?php
/**
 * Theme Customizer
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function mallow_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport        = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';
}

add_action( 'customize_register', 'mallow_customize_register' );


/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function mallow_customize_preview_js() {
	wp_enqueue_script(
		'mallow-customize-preview',
		get_template_directory_uri() . '/js/customizer-preview.js',
		array( 'customize-preview' ),
		'20160710',
		true
	);
}

add_action( 'customize_preview_init', 'mallow_customize_preview_js' );


/**
 * Bind JS in Customizer Controls
 */
function mallow_customize_promo_js() {
	wp_enqueue_script(
		'mallow-customize-promo',
		get_template_directory_uri() . '/js/customizer-promo.js',
		array( 'customize-controls' ),
		'20160710',
		true
	);

	// Pass to the JavaScript
	wp_localize_script(
		'mallow-customize-promo',
		'_mallowPROMO',
		array(
			'button' => esc_html__( 'Upgrade to Mallow Pro', 'mallow' ),
			'colors' => esc_html__( 'Check out Mallow Pro for full control over site color styling!', 'mallow' )
		)
	);
}

add_action( 'customize_controls_print_scripts', 'mallow_customize_promo_js' );