<?php
/**
 * Mallow back compat functionality
 *
 * Prevents Mallow from running on WordPress versions prior to 4.5,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 4.5.
 */

/**
 * Prevent switching to Mallow on old versions of WordPress.
 *
 * Switches to the default theme.
 */
function mallow_switch_theme() {
	switch_theme( WP_DEFAULT_THEME, WP_DEFAULT_THEME );

	unset( $_GET['activated'] );

	add_action( 'admin_notices', 'mallow_upgrade_notice' );
}

add_action( 'after_switch_theme', 'mallow_switch_theme' );


/**
 * Adds a message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * Mallow on WordPress versions prior to 4.5.
 *
 * @global string $wp_version WordPress version.
 */
function mallow_upgrade_notice() {
	/* translators: %s. Current version of WordPress */
	$message = sprintf( esc_html__( 'Mallow requires at least WordPress version 4.5. You are running version %s. Please upgrade and try again.', 'mallow' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}


/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 4.5.
 *
 * @global string $wp_version WordPress version.
 */
function mallow_customize() {
	/* translators: %s. Current version of WordPress */
	wp_die( sprintf( esc_html__( 'Mallow requires at least WordPress version 4.5. You are running version %s. Please upgrade and try again.', 'mallow' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}

add_action( 'load-customize.php', 'mallow_customize' );


/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 4.5.
 *
 * @global string $wp_version WordPress version.
 */
function mallow_preview() {
	if ( isset( $_GET['preview'] ) ) {
		/* translators: %s. Current version of WordPress */
		wp_die( sprintf( esc_html__( 'Mallow requires at least WordPress version 4.5. You are running version %s. Please upgrade and try again.', 'mallow' ), $GLOBALS['wp_version'] ) );
	}
}

add_action( 'template_redirect', 'mallow_preview' );
