<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
	<?php endif; ?>

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">

	<header id="masthead" class="site-header group" role="banner">

		<?php if ( has_nav_menu( 'primary' ) ) : ?>
			<nav class="site-navigation primary-navigation">
				<?php wp_nav_menu( array(
					'theme_location' => 'primary',
					'menu_class'     => 'menu group',
					'container'      => false
				) ); ?>
			</nav>
		<?php endif; ?>

		<div class="header-content">
			<div class="logo boxed group">
				<?php mallow_site_brand(); ?>
			</div>

			<div class="current-date">
				<div>
					<?php echo date( 'D, ' . get_option( 'date_format' ), current_time( 'timestamp', 1 ) ); ?>
				</div>
			</div>

			<div id="search-header" class="boxed"><?php get_search_form(); ?></div>
		</div>

		<?php if ( has_nav_menu( 'secondary' ) ) : ?>
			<nav role="navigation" class="site-navigation secondary-navigation group">
				<?php wp_nav_menu( array(
					'theme_location' => 'secondary',
					'menu_class'     => 'menu group'
				) ); ?>
			</nav>
		<?php endif; ?>

	</header>

	<div id="main" class="site-main boxed group">
