<?php

/**
 * Mallow only works in WordPress 4.5 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '4.5', '<' ) ) {
	require get_template_directory() . '/inc/back-compat.php';
}


if ( ! function_exists( 'mallow_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which runs
	 * before the init hook. The init hook is too late for some features, such as indicating
	 * support post thumbnails.
	 */
	function mallow_setup() {
		/**
		 * Make theme available for translation
		 * Translations can be filed in the /languages/ directory
		 * If you're building a theme based on fancythemes, use a find and replace
		 * to change 'mallow' to the name of your theme in all the template files
		 */
		load_theme_textdomain( 'mallow', get_template_directory() . '/languages' );

		/**
		 * Add default posts and comments RSS feed links to head
		 */
		add_theme_support( 'automatic-feed-links' );

		/**
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/**
		 * Enable support for custom logo.
		 */
		add_theme_support( 'custom-logo', array(
			'height'     => 80,
			'width'      => 266,
			'flex-width' => true,
		) );

		/**
		 * Enable support for Post Thumbnails
		 */
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 300, 300, true );

		/**
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		/**
		 * Enable support for Post Formats.
		 *
		 * See: https://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array(
			'aside',
			'image',
			'video',
			'quote',
			'link',
			'gallery',
			'status',
			'audio',
			'chat',
		) );

		/**
		 * This theme uses wp_nav_menu() in one location.
		 */
		register_nav_menus( array(
			'primary'   => esc_html__( 'Primary Menu', 'mallow' ),
			'secondary' => esc_html__( 'Secondary Menu', 'mallow' ),
			'footer'    => esc_html__( 'Footer Menu', 'mallow' ),
		) );

		/**
		 * Adding styling to the editor
		 */
		add_editor_style( 'style-editor.css' );

		/**
		 * Remove Default CSS for gallery
		 */
		add_filter( 'use_default_gallery_style', '__return_false' );
	}

endif;

add_action( 'after_setup_theme', 'mallow_setup' );


/**
 * Sets the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function mallow_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'mallow_content_width', 900 );
}

add_action( 'after_setup_theme', 'mallow_content_width', 0 );


/**
 * Setup the WordPress core custom background feature.
 */
function mallow_register_custom_background() {

	add_theme_support( 'custom-background', apply_filters( 'mallow_custom_background_args', array(
		'default-color' => 'ffffff',
	) ) );

}

add_action( 'after_setup_theme', 'mallow_register_custom_background' );


/**
 * Register widgetized area and update sidebar with default widgets
 */
function mallow_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'Sidebar', 'mallow' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Header Sidebar', 'mallow' ),
		'id'            => 'sidebar-header',
		'before_widget' => '<div id="%1$s" class="widget %2$s group">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 1', 'mallow' ),
		'id'            => 'footer-sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 2', 'mallow' ),
		'id'            => 'footer-sidebar-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Widget 3', 'mallow' ),
		'id'            => 'footer-sidebar-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
}

add_action( 'widgets_init', 'mallow_widgets_init' );


/**
 * Registers Widgets
 */
function mallow_register_widgets() {

	require( get_template_directory() . '/inc/widgets/recent_comments.php' );
	require( get_template_directory() . '/inc/widgets/recent_posts.php' );

	register_widget( 'Mallow_Widget_Recent_Comments' );
	register_widget( 'Mallow_Widget_Recent_Posts' );
}

add_action( 'widgets_init', 'mallow_register_widgets' );


/**
 * Enqueue scripts and styles
 */
function mallow_scripts() {
	/**
	 * Fonts
	 */	
	wp_enqueue_style( 'mallow-fonts', mallow_fonts_url(), array(), null );
	/**
	 * Load Theme Styles
	 */
	wp_enqueue_style( 'mallow-style', get_stylesheet_uri() );

	/**
	 * Load Theme Scripts
	 */
	wp_enqueue_script( 'jquery-dlmenu', get_template_directory_uri() . '/js/vendor/jquery.dlmenu.js', array( 'jquery' ), '20160810', true );
	wp_enqueue_script( 'jquery-fitvids', get_template_directory_uri() . '/js/vendor/jquery.fitvids.min.js', array( 'jquery' ), '20160810', true );
	wp_enqueue_script( 'mallow-script',
		get_template_directory_uri() . '/js/script.js',
		array(
			'jquery',
			'jquery-dlmenu',
			'jquery-fitvids'
		), '20160810', true );

	// Pass data to the JavaScript
	wp_localize_script(
		'mallow-script',
		'_mallowJS',
		array(
			'button_loading'   => esc_html__( 'Loading...', 'mallow' ),
			'button_load_more' => esc_html__( 'Load More', 'mallow' )
		)
	);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	if ( is_singular() && wp_attachment_is_image() ) {
		wp_enqueue_script( 'mallow-keyboard-image-navigation', get_template_directory_uri() . '/js/keyboard-image-navigation.js', array( 'jquery' ), '20160810' );
	}
}
add_action( 'wp_enqueue_scripts', 'mallow_scripts' );

if ( ! function_exists( 'mallow_fonts_url' ) ) :
/**
 * Register Google fonts for Mallow.
 *
 * Create your own mallow_fonts_url() function to override in a child theme.
 *
 */
function mallow_fonts_url() {
	$fonts_url = '';
	$fonts     = array();
	$subsets   = 'latin,latin-ext';

	/* translators: If there are characters in your language that are not supported by Lora, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Lora font: on or off', 'mallow' ) ) {
		$fonts[] = 'Lora:400,400i,700,700i';
	}

	/* translators: If there are characters in your language that are not supported by Montserrat, translate this to 'off'. Do not translate into your own language. */
	if ( 'off' !== _x( 'on', 'Montserrat font: on or off', 'mallow' ) ) {
		$fonts[] = 'Montserrat:400,400i,700,700i';
	}

	if ( $fonts ) {
		$fonts_url = add_query_arg( array(
			'family' => urlencode( implode( '|', $fonts ) ),
			'subset' => urlencode( $subsets ),
		), 'https://fonts.googleapis.com/css' );
	}

	return $fonts_url;
}
endif;

/**
 * Customizer additions
 */
require( get_template_directory() . '/inc/customizer.php' );

/**
 * Custom template tags for this theme.
 */
require( get_template_directory() . '/inc/template-tags.php' );

/**
 * Custom functions that act independently of the theme templates
 */
require( get_template_directory() . '/inc/extras.php' );

/**
 * Add theme info page
 */
require get_template_directory() . '/inc/dashboard.php';