<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the id=main div and all content after
 */
?>

		</div>

		<footer id="colophon" class="site-footer" role="contentinfo">
			<?php if ( is_active_sidebar( 'footer-sidebar-1' ) ||
			           is_active_sidebar( 'footer-sidebar-2' ) ||
			           is_active_sidebar( 'footer-sidebar-3' )
			) : ?>
				<div id="footer-widgets" class="clearfix">
					<?php if ( is_active_sidebar( 'footer-sidebar-1' ) ) : ?>
						<div class="footer-widget boxed">
							<?php dynamic_sidebar( 'footer-sidebar-1' ); ?>
						</div>
					<?php endif; ?>
					<?php if ( is_active_sidebar( 'footer-sidebar-2' ) ) : ?>
						<div class="footer-widget boxed">
							<?php dynamic_sidebar( 'footer-sidebar-2' ); ?>
						</div>
					<?php endif; ?>
					<?php if ( is_active_sidebar( 'footer-sidebar-3' ) ) : ?>
						<div class="footer-widget boxed">
							<?php dynamic_sidebar( 'footer-sidebar-3' ); ?>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<div class="site-info">
				<?php if ( has_nav_menu( 'footer' ) ) : ?>
					<?php wp_nav_menu( array(
						'theme_location' => 'footer',
						'menu_class'     => 'footer-menu',
						'depth'          => 1
					) ); ?>
				<?php endif; ?>

				<span class="footer-credit"><?php
					echo apply_filters( 'mallow_footer_credit', sprintf(
						/* translators: 1. Site name 2. Current Year 3. WordPress Link 4. FancyThemes Link */
						__( '&copy; %1$s %2$d. Powered by %3$s &amp; %4$s', 'mallow' ),
						get_bloginfo( 'name' ),
						date( 'Y' ),
						sprintf(
							'<a href="%1$s" title="%2$s">%3$s</a>',
							'https://wordpress.org/',
							esc_attr__( 'WordPress', 'mallow' ),
							esc_html__( 'WordPress', 'mallow' )
						),
						sprintf(
							'<a href="%1$s" rel="dofollow" title="%2$s">%3$s</a>',
							'https://fancythemes.com/',
							esc_attr__( 'FancyThemes', 'mallow' ),
							esc_html__( 'FancyThemes', 'mallow' )
						)
					) ); ?></span>
			</div>
		</footer>

	</div>

<?php wp_footer(); ?>
</body>
</html>