<?php
/**
* Template part for displaying single posts.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/
?>

<?php magpal_before_single_post(); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class('magpal-post-singular'); ?>>
<div class="magpal-post-singular-inside">

    <?php magpal_before_single_post_title(); ?>

    <?php if ( !(magpal_get_option('hide_single_breadcrumbs')) ) { ?>
        <?php if ( function_exists('yoast_breadcrumb') ) { ?>
            <?php yoast_breadcrumb( '<div class="magpal-entry-meta-single magpal-entry-meta-single-top magpal-entry-meta-single-breadcrumbs"><p id="magpal-yoast-breadcrumbs">','</p></div>' ); ?>
        <?php } ?>
    <?php } ?>

    <?php if ( !(magpal_get_option('hide_single_post_title')) ) { ?>
        <header class="entry-header">
            <div class="entry-header-inside magpal-clearfix">
                <?php if ( magpal_get_option('remove_single_post_title_link') ) { ?>
                    <?php the_title( '<div class="entry-header-title"><h1 class="post-title entry-title"><span class="singular-entry-title-inside">', '</span></h1></div>' ); ?>
                <?php } else { ?>
                    <?php the_title( sprintf( '<div class="entry-header-title"><h1 class="post-title entry-title"><span class="singular-entry-title-inside"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></span></h1></div>' ); ?>
                <?php } ?>
            </div>
        </header><!-- .entry-header -->
    <?php } ?>

    <?php magpal_single_postmeta(); ?>

    <?php magpal_after_single_post_title(); ?>

    <div class="entry-content magpal-clearfix">
        <?php
        magpal_top_single_post_content();

        the_content( sprintf(
            wp_kses(
                /* translators: %s: Name of current post. Only visible to screen readers */
                __( 'Continue reading<span class="screen-reader-text"> "%s"</span> <span class="meta-nav">&rarr;</span>', 'magpal' ),
                array(
                    'span' => array(
                        'class' => array(),
                    ),
                )
            ),
            wp_kses_post( get_the_title() )
        ) );

        wp_link_pages( array(
         'before'      => '<div class="magpal-clearfix"></div><div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'magpal' ) . '</span>',
         'after'       => '</div>',
         'link_before' => '<span>',
         'link_after'  => '</span>',
         ) );

        magpal_bottom_single_post_content();
        ?>
    </div><!-- .entry-content -->

    <?php magpal_after_single_post_content(); ?>

    <?php if ( !(magpal_get_option('hide_single_author_bio_box')) ) { ?>
        <?php echo wp_kses_post( force_balance_tags( magpal_add_author_bio_box() ) ); ?>
    <?php } ?>

    <?php if ( !(magpal_get_option('hide_single_post_tags')) ) { ?>
        <?php if ( has_tag() ) { ?>
            <footer class="entry-footer magpal-entry-footer">
                <div class="magpal-entry-footer-inside">
                    <?php magpal_post_tags(); ?>
                </div>
            </footer><!-- .entry-footer -->
        <?php } ?>
    <?php } ?>

</div>
</article>

<?php magpal_after_single_post(); ?>