<?php
/**
* Template part for displaying page content in page.php.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/
?>

<?php magpal_before_single_page(); ?>

<article id="post-<?php the_ID(); ?>" <?php post_class('magpal-post-singular'); ?>>
<div class="magpal-post-singular-inside">

    <?php magpal_before_single_page_title(); ?>

    <?php if ( !(magpal_get_option('hide_page_title')) ) { ?>
        <?php if ( !((is_front_page()) && (magpal_get_option('hide_static_page_title'))) ) { ?>
            <header class="entry-header">
                <div class="entry-header-inside magpal-clearfix">
                    <?php if ( magpal_get_option('remove_page_title_link') ) { ?>
                        <?php the_title( '<div class="entry-header-title"><h1 class="post-title entry-title"><span class="singular-entry-title-inside">', '</span></h1></div>' ); ?>
                    <?php } else { ?>
                        <?php the_title( sprintf( '<div class="entry-header-title"><h1 class="post-title entry-title"><span class="singular-entry-title-inside"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></span></h1></div>' ); ?>
                    <?php } ?>

                    <?php magpal_page_postmeta(); ?>
                </div>
            </header><!-- .entry-header -->
        <?php } ?>
    <?php } ?>

    <?php magpal_after_single_page_title(); ?>

    <div class="entry-content magpal-clearfix">
        <?php
        the_content( sprintf(
            wp_kses(
                /* translators: %s: Name of current post. Only visible to screen readers */
                __( 'Continue reading<span class="screen-reader-text"> "%s"</span> <span class="meta-nav">&rarr;</span>', 'magpal' ),
                array(
                    'span' => array(
                        'class' => array(),
                    ),
                )
            ),
            wp_kses_post( get_the_title() )
        ) );

        wp_link_pages( array(
         'before'      => '<div class="magpal-clearfix"></div><div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'magpal' ) . '</span>',
         'after'       => '</div>',
         'link_before' => '<span>',
         'link_after'  => '</span>',
         ) );
         ?>
    </div><!-- .entry-content -->

    <?php magpal_after_single_page_content(); ?>

    <?php
        if ( !(magpal_get_option('hide_page_edit')) ) {
            edit_post_link(
                sprintf(
                    wp_kses(
                        /* translators: %s: Name of current post. Only visible to screen readers */
                        __( 'Edit <span class="screen-reader-text">%s</span>', 'magpal' ),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    wp_kses_post( get_the_title() )
                ),
                '<footer class="entry-footer magpal-entry-footer"><div class="magpal-entry-footer-inside"><span class="edit-link">',
                '</span></div></footer>'
            );
        }
    ?>

</div>
</article>

<?php magpal_after_single_page(); ?>