<?php
/**
* Template part for displaying a message that posts cannot be found.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/
?>

<div class="magpal-no-results magpal-not-found">
    <!-- Page Header -->
    <div class="magpal-page-header-outside">
        <header class="magpal-page-header">
            <div class="magpal-page-header-inside">
                <?php if ( magpal_get_option( 'no_search_heading' ) ) : ?>
                    <h1 class="page-title"><?php echo esc_html( magpal_get_option( 'no_search_heading' ) ); ?></h1>
                <?php else : ?>
                    <h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'magpal' ); ?></h1>
                <?php endif; ?>
            </div>
        </header>
    </div>

    <div class="magpal-page-content">
        <?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

            <p>
                <?php
                printf(
                    wp_kses(
                        /* translators: 1: link to WP admin new post page. */
                        __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'magpal' ),
                        array(
                            'a' => array(
                                'href' => array(),
                            ),
                        )
                    ),
                    esc_url( admin_url( 'post-new.php' ) )
                );
                ?>
            </p>

        <?php elseif ( is_search() ) : ?>

            <p>
                <?php 
                if ( magpal_get_option( 'no_search_results' ) ) {
                    echo wp_kses_post( force_balance_tags( magpal_get_option( 'no_search_results' ) ) );
                } else {
                    esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'magpal' );
                }
                ?>
            </p>

            <?php get_search_form(); ?>

        <?php else : ?>

            <p><?php esc_html_e( 'It seems we can’t find what you’re looking for. Perhaps searching can help.', 'magpal' ); ?></p>
            <?php get_search_form(); ?>

        <?php endif; ?>
    </div>
</div>