<?php
/**
* Template part for displaying posts.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/
?>

<?php $magpal_grid_post_content = get_the_content(); ?>
<div id="magpal-grid-post-<?php the_ID(); ?>" class="magpal-grid-post magpal-fixed-grid-col">
<div class="magpal-grid-post-inside">

    <?php magpal_media_content_grid(); ?>

    <div class="magpal-grid-post-details">
    <?php if ( !(magpal_get_option('hide_grid_post_categories')) && has_category() && ('post' == get_post_type()) ) { ?>
        <?php magpal_grid_cats(); ?>
    <?php } ?>

    <?php if ( !(magpal_get_option('hide_grid_post_title')) ) { ?>

    <?php if ( magpal_get_option('remove_grid_post_title_link') ) { ?>

        <?php if ( magpal_get_option('limit_grid_post_titles') ) { ?>
            <div class="magpal-grid-post-heading magpal-grid-post-block"><h3 class="magpal-grid-post-title"><?php echo esc_html( wp_trim_words( get_the_title(), magpal_grid_post_title_length(), '...' ) ); ?></h3></div>
        <?php } else { ?>
            <?php the_title( '<div class="magpal-grid-post-heading magpal-grid-post-block"><h3 class="magpal-grid-post-title">', '</h3></div>' ); ?>
        <?php } ?>

    <?php } else { ?>

        <?php if ( magpal_get_option('limit_grid_post_titles') ) { ?>
            <div class="magpal-grid-post-heading magpal-grid-post-block"><h3 class="magpal-grid-post-title"><a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark"><?php echo esc_html( wp_trim_words( get_the_title(), magpal_grid_post_title_length(), '...' ) ); ?></a></h3></div>
        <?php } else { ?>
            <?php the_title( sprintf( '<div class="magpal-grid-post-heading magpal-grid-post-block"><h3 class="magpal-grid-post-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3></div>' ); ?>
        <?php } ?>

    <?php } ?>

    <?php } ?>

    <?php if ( !(magpal_get_option('hide_grid_post_snippet')) ) { ?>
        <?php if ( !empty( $magpal_grid_post_content ) ) { ?>
            <?php if((magpal_grid_post_snippet_type() === 'postcontent')) { ?>
                <div class="magpal-grid-post-snippet magpal-grid-post-block"><div class="magpal-grid-post-snippet-inside"><?php echo esc_html( wp_trim_words( get_the_content(), magpal_grid_post_snippet_length(), '...' ) ); ?></div></div>
            <?php } else { ?>
                <div class="magpal-grid-post-snippet magpal-grid-post-excerpt magpal-grid-post-block"><div class="magpal-grid-post-snippet-inside"><?php the_excerpt(); ?></div></div>
            <?php } ?>
        <?php } ?>
    <?php } ?>

    <?php magpal_grid_postmeta(); ?>
    </div>

</div>
</div>