<?php
/**
* Off-Canvas Sidebar Template
*
* This file is responsible for displaying the off-canvas sidebar, 
* which can be toggled open and closed via a button.
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/

if ( magpal_is_sidebar_active() ) : ?>
    <div id="magpal-off-canvas-wrapper">
        <div class="magpal-off-canvas-overlay"></div>
        <div id="magpal-off-canvas-sidebar" class="magpal-off-canvas-sidebar">
            <div class="magpal-off-canvas-content">
                <?php if ( is_active_sidebar( 'magpal-off-canvas-sidebar' ) ) : ?>
                    <?php dynamic_sidebar( 'magpal-off-canvas-sidebar' ); ?>
                <?php else : ?>
                    <p>
                        <?php esc_html_e( 'Add widgets to this off-canvas sidebar by going to your "WordPress Dashboard" : "Appearance" : "Widgets".', 'magpal' ); ?>
                    </p>
                <?php endif; ?>

                <button id="magpal-close-off-canvas" class="magpal-close-off-canvas" aria-label="<?php esc_attr_e( 'Close Sidebar', 'magpal' ); ?>">&#xD7;</button>
            </div>
        </div>
    </div>
<?php endif; ?>