<?php
/**
* The file for displaying the search form
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/
?>

<form role="search" method="get" class="magpal-search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
<label>
    <span class="screen-reader-text"><?php echo esc_html_x( 'Search for:', 'label', 'magpal' ); ?></span>
    <input type="search" class="magpal-search-field" placeholder="<?php echo esc_attr( magpal_search_box_placeholder_text() ); ?>" value="<?php echo get_search_query(); ?>" name="s" />
</label>
<input type="submit" class="magpal-search-submit" value="<?php echo esc_attr_x( '&#xf002;', 'submit button', 'magpal' ); ?>" />
</form>