<?php
/**
* The template for displaying search results pages.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/

get_header();

// If Elementor is handling the search.php, exit early (it will load its own content)
if ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'archive' ) ) {
    get_footer();
    return;
}
?>

<?php magpal_before_main_content(); ?>

<div id="magpal-posts-wrapper" class="magpal-posts-wrapper" itemscope itemtype="http://schema.org/Blog" role="main">
    <div class="magpal-outer-wrapper magpal-posts-outer-wrapper">
        <div class="magpal-posts-wrapper-inside magpal-clearfix">

            <!-- Page Header -->
            <?php if ( ! magpal_get_option( 'hide_search_results_heading' ) ) : ?>
                <div class="magpal-page-header-outside">
                    <header class="magpal-page-header">
                        <div class="magpal-page-header-inside">
                            <h1 class="page-title">
                                <?php
                                $search_heading = magpal_get_option( 'search_results_heading' ) ?: __( 'Search Results for:', 'magpal' );
                                echo esc_html( $search_heading );
                                ?>
                                <span><?php echo esc_html( get_search_query() ); ?></span>
                            </h1>
                        </div>
                    </header>
                </div>
            <?php endif; ?>

            <!-- Posts Content -->
            <div class="magpal-posts-content">
                <?php if ( have_posts() ) : ?>
                    <div class="magpal-posts magpal-posts-grid magpal-clearfix">
                        <div class="magpal-fixed-grid-col-sizer"></div>
                        <div class="magpal-fixed-grid-col-gutter"></div>

                        <?php while ( have_posts() ) : the_post(); ?>
                            <?php get_template_part( 'template-parts/content-grid' ); ?>
                        <?php endwhile; ?>
                    </div>

                    <!-- Posts Navigation -->
                    <?php magpal_posts_navigation(); ?>
                <?php else : ?>
                    <!-- No Posts Template -->
                    <?php get_template_part( 'template-parts/content', 'none' ); ?>
                <?php endif; ?>
            </div>

        </div>
    </div>
</div>

<?php magpal_after_main_content(); ?>

<?php get_footer(); ?>