<?php
/**
* The template for displaying all pages.
*
* This is the template that displays all pages by default.
* Please note that this is the WordPress construct of pages
* and that other 'pages' on your WordPress site may use a
* different template.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-page
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/

get_header();

// If Elementor is handling the page.php, exit early (it will load its own content)
if ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'single' ) ) {
    get_footer();
    return;
}
?>

<?php magpal_before_main_content(); ?>

<div id="magpal-singular-wrapper" class="magpal-singular-wrapper" itemscope itemtype="http://schema.org/Blog" role="main">
    <div class="magpal-outer-wrapper magpal-singular-outer-wrapper">
        <div class="magpal-singular-wrapper-inside magpal-clearfix">

            <div class="magpal-singular-content magpal-clearfix">

                <?php while ( have_posts() ) : the_post(); ?>

                    <!-- Post Content -->
                    <div class="magpal-post-content-wrapper">
                        <div class="magpal-outer-wrapper magpal-post-content-outer-wrapper">
                            <?php get_template_part( 'template-parts/content', 'page' ); ?>
                        </div>
                    </div>

                    <!-- Comments Section -->
                    <?php if ( ! magpal_get_option( 'hide_page_comment_form' ) ) : ?>
                        <?php if ( comments_open() || get_comments_number() ) : ?>
                            <div class="magpal-comments-wrapper">
                                <div class="magpal-outer-wrapper magpal-post-content-outer-wrapper">
                                    <?php comments_template(); ?>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                <?php endwhile; ?>

            </div>

        </div>
    </div>
</div><!--/#magpal-singular-wrapper -->

<?php magpal_after_main_content(); ?>

<?php get_footer(); ?>