<?php
/**
* The main template file.
*
* This is the most generic template file in a WordPress theme
* and one of the two required files for a theme (the other being style.css).
* It is used to display a page when nothing more specific matches a query.
* E.g., it puts together the home page when no home.php file exists.
*
* @link https://developer.wordpress.org/themes/basics/template-hierarchy/
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/

get_header();

// If Elementor is handling the index.php, exit early (it will load its own content)
if ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'archive' ) ) {
    get_footer();
    return;
}
?>

<?php magpal_before_main_content(); ?>

<div id="magpal-posts-wrapper" class="magpal-posts-wrapper" itemscope itemtype="http://schema.org/Blog" role="main">
    <div class="magpal-outer-wrapper magpal-posts-outer-wrapper">
        <div class="magpal-posts-wrapper-inside magpal-clearfix">

            <!-- Posts Heading -->
            <?php if ( ! magpal_get_option( 'hide_posts_heading' ) && is_home() && ! is_paged() ) : ?>
                <div class="magpal-posts-header">
                    <h2 class="magpal-posts-heading">
                        <span class="magpal-posts-heading-inside">
                            <?php
                            echo esc_html( magpal_get_option( 'posts_heading' ) ?: __( 'Recent Posts', 'magpal' ) );
                            ?>
                        </span>
                    </h2>
                </div>
            <?php endif; ?>

            <!-- Posts Content -->
            <div class="magpal-posts-content">
                <?php if ( have_posts() ) : ?>
                    <div class="magpal-posts magpal-posts-grid magpal-clearfix">
                        <div class="magpal-fixed-grid-col-sizer"></div>
                        <div class="magpal-fixed-grid-col-gutter"></div>

                        <?php while ( have_posts() ) : the_post(); ?>
                            <?php get_template_part( 'template-parts/content-grid' ); ?>
                        <?php endwhile; ?>
                    </div>

                    <!-- Posts Navigation -->
                    <?php magpal_posts_navigation(); ?>

                <?php else : ?>

                    <!-- No Posts Template -->
                    <?php get_template_part( 'template-parts/content', 'none' ); ?>

                <?php endif; ?>
            </div>

        </div>
    </div>
</div>

<?php magpal_after_main_content(); ?>

<?php get_footer(); ?>