<?php
/**
* The header for MagPal theme.
*
* @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> id="magpal-site-body" itemscope="itemscope" itemtype="http://schema.org/WebPage">
<?php wp_body_open(); ?>
<?php magpal_skip_link(); ?>

<div class="magpal-site-container">

<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'header' ) ) { ?>

<?php magpal_before_header(); ?>

<?php magpal_header_image(); ?>

<div id="magpal-header" class="magpal-site-header magpal-clearfix" itemscope itemtype="http://schema.org/WPHeader" role="banner">
<div id="magpal-head-content" class="magpal-head-content magpal-clearfix">

<?php if ( magpal_is_header_content_active() ) : ?>
    <div class="magpal-header-inside magpal-clearfix">
        <div class="magpal-header-inside-content magpal-clearfix">
            <div class="magpal-outer-wrapper magpal-header-outer-wrapper">
                <div class="magpal-header-inside-container">

                    <!-- Logo Section -->
                    <div class="magpal-header-layout-logo magpal-header-layout-item">
                        <div class="magpal-header-layout-logo-inside magpal-header-layout-item-inside">
                            <?php if ( has_custom_logo() ) : ?>
                                <div class="site-branding site-branding-full">
                                    <div class="magpal-custom-logo-image">
                                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" class="magpal-logo-img-link">
                                            <img src="<?php echo esc_url( magpal_custom_logo() ); ?>" alt="" class="magpal-logo-img" />
                                        </a>
                                    </div>
                                    <div class="magpal-logo-info magpal-custom-logo-info"><?php magpal_site_title(); ?></div>
                                </div>
                            <?php else : ?>
                                <div class="site-branding">
                                    <div class="magpal-logo-info"><?php magpal_site_title(); ?></div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <!-- Primary Menu -->
                    <div class="magpal-header-layout-menu magpal-header-layout-item">
                        <div class="magpal-header-layout-menu-inside magpal-header-layout-item-inside">
                            <nav class="magpal-nav-primary" id="magpal-primary-navigation" itemscope itemtype="http://schema.org/SiteNavigationElement" role="navigation" aria-label="<?php esc_attr_e( 'Primary Menu', 'magpal' ); ?>">
                                <?php wp_nav_menu( [
                                    'theme_location' => 'primary',
                                    'menu_id'        => 'magpal-menu-primary-navigation',
                                    'menu_class'     => 'magpal-primary-nav-menu magpal-menu-primary magpal-clearfix',
                                    'fallback_cb'    => 'magpal_primary_fallback_menu',
                                    'container'      => '',
                                ] ); ?>
                            </nav>
                        </div>
                    </div>

                    <!-- Header Icons -->
                    <div class="magpal-header-layout-icons magpal-header-layout-item">
                        <div class="magpal-header-layout-icons-inside magpal-header-layout-item-inside">
                            <div class="magpal-header-icons">

                                <!-- Responsive Menu Button -->
                                <?php if ( magpal_is_primary_menu_active() && magpal_is_primary_menu_responsive() ) : ?>
                                    <div id="magpal-primary-menu-mobile-button" class="magpal-primary-menu-mobile-button">
                                        <button class="magpal-primary-responsive-menu-icon" aria-controls="magpal-menu-primary-navigation" aria-expanded="false">
                                            <i class="fas fa-bars" aria-hidden="true" title="<?php esc_attr_e( 'Menu', 'magpal' ); ?>"></i>
                                            <?php if ( magpal_primary_menu_text() ) : ?>
                                                &nbsp;<?php echo esc_html( magpal_primary_menu_text() ); ?>
                                            <?php endif; ?>
                                        </button>
                                    </div>
                                <?php endif; ?>

                                <!-- Search Icon -->
                                <?php if ( ! magpal_get_option( 'hide_header_search_button' ) ) : ?>
                                    <a href="#" class="magpal-header-icon-search" aria-label="<?php esc_attr_e( 'Search Button', 'magpal' ); ?>">
                                        <i class="fas fa-search" aria-hidden="true" title="<?php esc_attr_e( 'Search', 'magpal' ); ?>"></i>
                                    </a>
                                <?php endif; ?>

                                <!-- Sidebar Icon -->
                                <?php if ( magpal_is_sidebar_active() ) : ?>
                                    <a href="#" class="magpal-open-sidebar-link" aria-label="<?php esc_attr_e( 'Sidebar Button', 'magpal' ); ?>">
                                        <i class="fas fa-right-to-bracket" aria-hidden="true" title="<?php esc_attr_e( 'Sidebar', 'magpal' ); ?>"></i>
                                    </a>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
<?php else : ?>
    <div class="magpal-no-header-content">
        <?php magpal_site_title(); ?>
    </div>
<?php endif; ?>

</div><!--/#magpal-head-content -->
</div><!--/#magpal-header -->

<?php if ( ! magpal_get_option( 'hide_header_search_button' ) ) : ?>
<div id="magpal-search-overlay-wrap" class="magpal-search-overlay">
    <div class="magpal-search-overlay-content">
        <?php get_search_form(); ?>
    </div>
    <button class="magpal-search-close-btn" aria-label="<?php esc_attr_e( 'Close Search', 'magpal' ); ?>" title="<?php esc_attr_e( 'Close Search', 'magpal' ); ?>">&#xD7;</button>
</div>
<?php endif; ?>

<?php magpal_after_header(); ?>

<div id="magpal-header-end"></div>

<?php } ?>