<?php
/**
* The template for displaying the footer
*
* @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/
?>

<?php if ( ! function_exists( 'elementor_theme_do_location' ) || ! elementor_theme_do_location( 'footer' ) ) { ?>

<?php magpal_before_footer(); ?>

<?php if ( magpal_is_footer_widgets_active() ) { ?>
<?php if ( is_active_sidebar( 'magpal-footer-1' ) || is_active_sidebar( 'magpal-footer-2' ) || is_active_sidebar( 'magpal-footer-3' ) || is_active_sidebar( 'magpal-footer-4' ) || is_active_sidebar( 'magpal-footer-5' ) || is_active_sidebar( 'magpal-top-footer' ) || is_active_sidebar( 'magpal-bottom-footer' ) ) : ?>
<div class="magpal-clearfix" id="magpal-footer-blocks" itemscope="itemscope" itemtype="http://schema.org/WPFooter" role="contentinfo">
<div class="magpal-outer-wrapper magpal-footer-outer-wrapper">

<?php if ( is_active_sidebar( 'magpal-top-footer' ) ) : ?>
<div class="magpal-clearfix">
<div class="magpal-top-footer-block">
<?php dynamic_sidebar( 'magpal-top-footer' ); ?>
</div>
</div>
<?php endif; ?>

<?php if ( is_active_sidebar( 'magpal-footer-1' ) || is_active_sidebar( 'magpal-footer-2' ) || is_active_sidebar( 'magpal-footer-3' ) || is_active_sidebar( 'magpal-footer-4' ) || is_active_sidebar( 'magpal-footer-5' ) ) : ?>
<div class="magpal-footer-block-cols magpal-clearfix">

<div class="magpal-footer-block-col magpal-footer-5-col" id="magpal-footer-block-1">
<?php dynamic_sidebar( 'magpal-footer-1' ); ?>
</div>

<div class="magpal-footer-block-col magpal-footer-5-col" id="magpal-footer-block-2">
<?php dynamic_sidebar( 'magpal-footer-2' ); ?>
</div>

<div class="magpal-footer-block-col magpal-footer-5-col" id="magpal-footer-block-3">
<?php dynamic_sidebar( 'magpal-footer-3' ); ?>
</div>

<div class="magpal-footer-block-col magpal-footer-5-col" id="magpal-footer-block-4">
<?php dynamic_sidebar( 'magpal-footer-4' ); ?>
</div>

<div class="magpal-footer-block-col magpal-footer-5-col" id="magpal-footer-block-5">
<?php dynamic_sidebar( 'magpal-footer-5' ); ?>
</div>

</div>
<?php endif; ?>

<?php if ( is_active_sidebar( 'magpal-bottom-footer' ) ) : ?>
<div class="magpal-clearfix">
<div class="magpal-bottom-footer-block">
<?php dynamic_sidebar( 'magpal-bottom-footer' ); ?>
</div>
</div>
<?php endif; ?>

</div>
</div><!--/#magpal-footer-blocks-->
<?php endif; ?>
<?php } ?>

<?php magpal_secondary_menu_area(); ?>

<div class="magpal-clearfix" id="magpal-copyright-area">
<div class="magpal-copyright-area-inside magpal-clearfix">
<div class="magpal-outer-wrapper magpal-footer-outer-wrapper">

<?php if ( magpal_is_footer_social_buttons_active() ) { ?>
<div class="magpal-copyright-area-inside-social">
<?php magpal_footer_social_buttons(); ?>
</div>
<?php } ?>

<div class="magpal-copyright-area-inside-text">
<?php if ( magpal_get_option('footer_text') ) : ?>
  <span class="magpal-copyright magpal-cc-block"><?php echo wp_kses_post( force_balance_tags( magpal_get_option('footer_text') ) ); ?></span>
<?php else : ?>
  <span class="magpal-copyright magpal-cc-block"><?php /* translators: %s: Year and site name. */ printf( esc_html__( 'Copyright &copy; %s', 'magpal' ), esc_html(date_i18n(__('Y','magpal'))) . ' ' . esc_html(get_bloginfo( 'name' ))  ); ?></span>
<?php endif; ?>
  <span class="magpal-credit magpal-cc-block"><a href="<?php echo esc_url( 'https://themesdna.com/' ); ?>"><?php /* translators: %s: Theme author. */ printf( esc_html__( 'Design by %s', 'magpal' ), 'ThemesDNA.com' ); ?></a></span>
</div>

</div>
</div>
</div><!--/#magpal-copyright-area -->

<?php magpal_after_footer(); ?>

<?php } ?>

</div><!--/.magpal-site-container -->

<?php get_sidebar( 'offcanvas' ); ?>

<?php if ( magpal_is_backtotop_active() ) : ?>
    <button class="magpal-scroll-top" title="<?php esc_attr_e( 'Scroll to Top', 'magpal' ); ?>" aria-label="<?php esc_attr_e( 'Scroll to Top', 'magpal' ); ?>">
        <i class="fas fa-arrow-up" aria-hidden="true"></i>
        <span class="screen-reader-text"><?php esc_html_e( 'Scroll to Top', 'magpal' ); ?></span>
    </button>
<?php endif; ?>

<?php wp_footer(); ?>
</body>
</html>