/**
 * File navigation.js.
 *
 * Handles toggling the navigation menu for small screens and enables TAB key
 * navigation support for dropdown menus.
 */
( function() {
    var magpal_secondary_container, magpal_secondary_button, magpal_secondary_menu, magpal_secondary_links, magpal_secondary_i, magpal_secondary_len;

    magpal_secondary_container = document.getElementById( 'magpal-secondary-navigation' );
    if ( ! magpal_secondary_container ) {
        return;
    }

    magpal_secondary_button = magpal_secondary_container.getElementsByTagName( 'button' )[0];
    if ( 'undefined' === typeof magpal_secondary_button ) {
        return;
    }

    magpal_secondary_menu = magpal_secondary_container.getElementsByTagName( 'ul' )[0];

    // Hide menu toggle button if menu is empty and return early.
    if ( 'undefined' === typeof magpal_secondary_menu ) {
        magpal_secondary_button.style.display = 'none';
        return;
    }

    magpal_secondary_menu.setAttribute( 'aria-expanded', 'false' );
    if ( -1 === magpal_secondary_menu.className.indexOf( 'nav-menu' ) ) {
        magpal_secondary_menu.className += ' nav-menu';
    }

    magpal_secondary_button.onclick = function() {
        if ( -1 !== magpal_secondary_container.className.indexOf( 'magpal-toggled' ) ) {
            magpal_secondary_container.className = magpal_secondary_container.className.replace( ' magpal-toggled', '' );
            magpal_secondary_button.setAttribute( 'aria-expanded', 'false' );
            magpal_secondary_menu.setAttribute( 'aria-expanded', 'false' );
        } else {
            magpal_secondary_container.className += ' magpal-toggled';
            magpal_secondary_button.setAttribute( 'aria-expanded', 'true' );
            magpal_secondary_menu.setAttribute( 'aria-expanded', 'true' );
        }
    };

    // Get all the link elements within the menu.
    magpal_secondary_links    = magpal_secondary_menu.getElementsByTagName( 'a' );

    // Each time a menu link is focused or blurred, toggle focus.
    for ( magpal_secondary_i = 0, magpal_secondary_len = magpal_secondary_links.length; magpal_secondary_i < magpal_secondary_len; magpal_secondary_i++ ) {
        magpal_secondary_links[magpal_secondary_i].addEventListener( 'focus', magpal_secondary_toggleFocus, true );
        magpal_secondary_links[magpal_secondary_i].addEventListener( 'blur', magpal_secondary_toggleFocus, true );
    }

    /**
     * Sets or removes .focus class on an element.
     */
    function magpal_secondary_toggleFocus() {
        var self = this;

        // Move up through the ancestors of the current link until we hit .nav-menu.
        while ( -1 === self.className.indexOf( 'nav-menu' ) ) {

            // On li elements toggle the class .focus.
            if ( 'li' === self.tagName.toLowerCase() ) {
                if ( -1 !== self.className.indexOf( 'magpal-focus' ) ) {
                    self.className = self.className.replace( ' magpal-focus', '' );
                } else {
                    self.className += ' magpal-focus';
                }
            }

            self = self.parentElement;
        }
    }

    /**
     * Toggles `focus` class to allow submenu access on tablets.
     */
    ( function( magpal_secondary_container ) {
        var touchStartFn, magpal_secondary_i,
            parentLink = magpal_secondary_container.querySelectorAll( '.menu-item-has-children > a, .page_item_has_children > a' );

        if ( 'ontouchstart' in window ) {
            touchStartFn = function( e ) {
                var menuItem = this.parentNode, magpal_secondary_i;

                if ( ! menuItem.classList.contains( 'magpal-focus' ) ) {
                    e.preventDefault();
                    for ( magpal_secondary_i = 0; magpal_secondary_i < menuItem.parentNode.children.length; ++magpal_secondary_i ) {
                        if ( menuItem === menuItem.parentNode.children[magpal_secondary_i] ) {
                            continue;
                        }
                        menuItem.parentNode.children[magpal_secondary_i].classList.remove( 'magpal-focus' );
                    }
                    menuItem.classList.add( 'magpal-focus' );
                } else {
                    menuItem.classList.remove( 'magpal-focus' );
                }
            };

            for ( magpal_secondary_i = 0; magpal_secondary_i < parentLink.length; ++magpal_secondary_i ) {
                parentLink[magpal_secondary_i].addEventListener( 'touchstart', touchStartFn, false );
            }
        }
    }( magpal_secondary_container ) );
} )();


( function() {
    var magpal_primary_container, magpal_primary_button, magpal_primary_btn, magpal_primary_btn_wrapper, magpal_primary_menu, magpal_primary_links, magpal_primary_i, magpal_primary_len;

    magpal_primary_container = document.getElementById( 'magpal-primary-navigation' );
    if ( ! magpal_primary_container ) {
        return;
    }

    magpal_primary_btn_wrapper = document.getElementById( 'magpal-primary-menu-mobile-button' );
    if ( ! magpal_primary_btn_wrapper ) {
        return;
    }

    magpal_primary_btn = magpal_primary_btn_wrapper.getElementsByTagName( 'button' )[0];
    if ( 'undefined' === typeof magpal_primary_btn ) {
        return;
    }

    magpal_primary_menu = magpal_primary_container.getElementsByTagName( 'ul' )[0];

    // Hide menu toggle button if menu is empty and return early.
    if ( 'undefined' === typeof magpal_primary_menu ) {
        magpal_primary_btn.style.display = 'none';
        return;
    }

    magpal_primary_menu.setAttribute( 'aria-expanded', 'false' );
    if ( -1 === magpal_primary_menu.className.indexOf( 'nav-menu' ) ) {
        magpal_primary_menu.className += ' nav-menu';
    }

    magpal_primary_btn.onclick = function() {
        if ( -1 !== magpal_primary_container.className.indexOf( 'magpal-toggled' ) ) {
            magpal_primary_container.className = magpal_primary_container.className.replace( ' magpal-toggled', '' );
            magpal_primary_btn.setAttribute( 'aria-expanded', 'false' );
            magpal_primary_menu.setAttribute( 'aria-expanded', 'false' );
        } else {
            magpal_primary_container.className += ' magpal-toggled';
            magpal_primary_btn.setAttribute( 'aria-expanded', 'true' );
            magpal_primary_menu.setAttribute( 'aria-expanded', 'true' );
        }
    };

    // Get all the link elements within the menu.
    magpal_primary_links    = magpal_primary_menu.getElementsByTagName( 'a' );

    // Each time a menu link is focused or blurred, toggle focus.
    for ( magpal_primary_i = 0, magpal_primary_len = magpal_primary_links.length; magpal_primary_i < magpal_primary_len; magpal_primary_i++ ) {
        magpal_primary_links[magpal_primary_i].addEventListener( 'focus', magpal_primary_toggleFocus, true );
        magpal_primary_links[magpal_primary_i].addEventListener( 'blur', magpal_primary_toggleFocus, true );
    }

    /**
     * Sets or removes .focus class on an element.
     */
    function magpal_primary_toggleFocus() {
        var self = this;

        // Move up through the ancestors of the current link until we hit .nav-menu.
        while ( -1 === self.className.indexOf( 'nav-menu' ) ) {

            // On li elements toggle the class .focus.
            if ( 'li' === self.tagName.toLowerCase() ) {
                if ( -1 !== self.className.indexOf( 'magpal-focus' ) ) {
                    self.className = self.className.replace( ' magpal-focus', '' );
                } else {
                    self.className += ' magpal-focus';
                }
            }

            self = self.parentElement;
        }
    }

    /**
     * Toggles `focus` class to allow submenu access on tablets.
     */
    ( function( magpal_primary_container ) {
        var touchStartFn, magpal_primary_i,
            parentLink = magpal_primary_container.querySelectorAll( '.menu-item-has-children > a, .page_item_has_children > a' );

        if ( 'ontouchstart' in window ) {
            touchStartFn = function( e ) {
                var menuItem = this.parentNode, magpal_primary_i;

                if ( ! menuItem.classList.contains( 'magpal-focus' ) ) {
                    e.preventDefault();
                    for ( magpal_primary_i = 0; magpal_primary_i < menuItem.parentNode.children.length; ++magpal_primary_i ) {
                        if ( menuItem === menuItem.parentNode.children[magpal_primary_i] ) {
                            continue;
                        }
                        menuItem.parentNode.children[magpal_primary_i].classList.remove( 'magpal-focus' );
                    }
                    menuItem.classList.add( 'magpal-focus' );
                } else {
                    menuItem.classList.remove( 'magpal-focus' );
                }
            };

            for ( magpal_primary_i = 0; magpal_primary_i < parentLink.length; ++magpal_primary_i ) {
                parentLink[magpal_primary_i].addEventListener( 'touchstart', touchStartFn, false );
            }
        }
    }( magpal_primary_container ) );
} )();