jQuery(document).ready(function($) {
    'use strict';

    if(magpal_ajax_object.secondary_menu_active){
        if(magpal_ajax_object.secondary_mobile_menu_active){

        $(".magpal-nav-secondary .magpal-secondary-nav-menu").addClass("magpal-secondary-responsive-menu");

        $( ".magpal-secondary-responsive-menu-icon" ).on( "click", function() {
            $(this).next(".magpal-nav-secondary .magpal-secondary-nav-menu").slideToggle();
        });

        $(window).on( "resize", function() {
            if(window.innerWidth > 1112) {
                $(".magpal-nav-secondary .magpal-secondary-nav-menu, nav .sub-menu, nav .children").removeAttr("style");
                $(".magpal-secondary-responsive-menu > li").removeClass("magpal-secondary-menu-open");
            }
        });

        $( ".magpal-secondary-responsive-menu > li" ).on( "click", function(event) {
            if (event.target !== this)
            return;
            $(this).find(".sub-menu:first").toggleClass('magpal-submenu-toggle').parent().toggleClass("magpal-secondary-menu-open");
            $(this).find(".children:first").toggleClass('magpal-submenu-toggle').parent().toggleClass("magpal-secondary-menu-open");
        });

        $( "div.magpal-secondary-responsive-menu > ul > li" ).on( "click", function(event) {
            if (event.target !== this)
                return;
            $(this).find("ul:first").toggleClass('magpal-submenu-toggle').parent().toggleClass("magpal-secondary-menu-open");
        });

        }
    }

    if(magpal_ajax_object.primary_menu_active){
        if(magpal_ajax_object.primary_mobile_menu_active){

        $(".magpal-nav-primary .magpal-primary-nav-menu").addClass("magpal-primary-responsive-menu");

        $( ".magpal-primary-responsive-menu-icon" ).on( "click", function() {
            $(this).next(".magpal-nav-primary .magpal-primary-nav-menu").slideToggle();
            $(".magpal-nav-primary .magpal-primary-nav-menu").slideToggle();
        });

        $(window).on( "resize", function() {
            if(window.innerWidth > 1112) {
                $(".magpal-nav-primary .magpal-primary-nav-menu, nav .sub-menu, nav .children").removeAttr("style");
                $(".magpal-primary-responsive-menu > li").removeClass("magpal-primary-menu-open");
            }
        });

        $( ".magpal-primary-responsive-menu > li" ).on( "click", function(event) {
            if (event.target !== this)
            return;
            $(this).find(".sub-menu:first").toggleClass('magpal-submenu-toggle').parent().toggleClass("magpal-primary-menu-open");
            $(this).find(".children:first").toggleClass('magpal-submenu-toggle').parent().toggleClass("magpal-primary-menu-open");
        });

        $( "div.magpal-primary-responsive-menu > ul > li" ).on( "click", function(event) {
            if (event.target !== this)
                return;
            $(this).find("ul:first").toggleClass('magpal-submenu-toggle').parent().toggleClass("magpal-primary-menu-open");
        });

        }
    }

    if($(".magpal-primary-responsive-menu-icon").length){
        $(".magpal-primary-responsive-menu-icon").on('click', function (e) {
            e.preventDefault();
            //document.getElementById("magpal-search-overlay-wrap").style.display = "block";
            //$("#magpal-search-overlay-wrap").fadeIn();
            const magpal_focusableelements = 'a, button, [href], input';
            const magpal_search_modal = document.querySelector('#magpal-menu-primary-navigation');
            const magpal_firstfocusableelement = magpal_search_modal.querySelectorAll(magpal_focusableelements)[0];
            const magpal_focusablecontent = magpal_search_modal.querySelectorAll(magpal_focusableelements);
            const magpal_lastfocusableelement = magpal_focusablecontent[magpal_focusablecontent.length - 1];
            document.addEventListener('keydown', function(e) {
              let isTabPressed = e.key === 'Tab' || e.keyCode === 9;
              if (!isTabPressed) {
                return;
              }
              if (e.shiftKey) {
                if (document.activeElement === magpal_firstfocusableelement) {
                  magpal_lastfocusableelement.focus();
                  e.preventDefault();
                }
              } else {
                if (document.activeElement === magpal_lastfocusableelement) {
                  magpal_firstfocusableelement.focus();
                  e.preventDefault();
                }
              }
            });
            magpal_firstfocusableelement.focus();
        });
    }

    if($(".magpal-mobile-menu-close").length){
        $(".magpal-mobile-menu-close").on('click', function (e) {
            e.preventDefault();
            $(".magpal-nav-primary .magpal-primary-nav-menu").slideToggle();
            $(".magpal-primary-menu-mobile-button .magpal-primary-responsive-menu-icon").focus();
        });
    }

    function magpal_search_overlay(options) {
        const { openButtonClass, closeButtonClass, overlayId } = options;

        const openButtons = document.querySelectorAll(`.${openButtonClass}`);
        const closeButtons = document.querySelectorAll(`.${closeButtonClass}`);
        const overlay = document.getElementById(overlayId);
        let lastFocusedElement = null; // Variable to store the last focused open button

        if (!openButtons.length || !closeButtons.length || !overlay) {
            //console.error("One or more required elements are missing.");
            return;
        }

        // Open Overlay
        const openOverlay = function (event) {
            if (event) {
                event.preventDefault();
                lastFocusedElement = event.target; // Store the clicked button
            }

            overlay.style.display = "block";

            // Focusable elements inside the overlay
            const focusableElements = 'button, [href], input, select, textarea, [tabindex]:not([tabindex="-1"])';
            const focusableContent = overlay.querySelectorAll(focusableElements);
            const firstFocusableElement = focusableContent[0];
            const lastFocusableElement = focusableContent[focusableContent.length - 1];

            // Trap focus within the overlay
            const handleFocusTrap = function (e) {
                const isTabPressed = e.key === 'Tab' || e.keyCode === 9;

                if (!isTabPressed) return;

                if (e.shiftKey) {
                    // Shift + Tab: Wrap focus to the last element
                    if (document.activeElement === firstFocusableElement) {
                        e.preventDefault();
                        lastFocusableElement.focus();
                    }
                } else {
                    // Tab: Wrap focus to the first element
                    if (document.activeElement === lastFocusableElement) {
                        e.preventDefault();
                        firstFocusableElement.focus();
                    }
                }
            };

            document.addEventListener('keydown', handleFocusTrap);

            // Automatically focus the first focusable element
            if (firstFocusableElement) {
                firstFocusableElement.focus();
            }

            // Close Overlay with cleanup
            const closeOverlayWithCleanup = function () {
                closeOverlay();
                document.removeEventListener('keydown', handleFocusTrap);
            };

            closeButtons.forEach((btn) => {
                btn.addEventListener('click', closeOverlayWithCleanup, { once: true });
            });
        };

        // Close Overlay
        const closeOverlay = function () {
            overlay.style.display = "none";

            // Return focus to the triggering button
            if (lastFocusedElement) {
                lastFocusedElement.focus();
            }
        };

        // Add event listeners to open buttons
        openButtons.forEach((btn) => {
            btn.addEventListener('click', openOverlay);
        });
    }

    if(magpal_ajax_object.search_overlay_active){
        magpal_search_overlay({
            openButtonClass: 'magpal-header-icon-search', // Class for the open button
            closeButtonClass: 'magpal-search-close-btn',  // Class for the close button
            overlayId: 'magpal-search-overlay-wrap'      // ID of the overlay
        });
    }

    if(magpal_ajax_object.fitvids_active){
        $(".entry-content, .widget").fitVids();
    }

    if(magpal_ajax_object.backtotop_active){
        if($(".magpal-scroll-top").length){
            var magpal_scroll_button = $( '.magpal-scroll-top' );
            magpal_scroll_button.hide();

            $(window).on( "scroll", function() {
                if ( $( window ).scrollTop() < 20 ) {
                    $( '.magpal-scroll-top' ).fadeOut();
                } else {
                    $( '.magpal-scroll-top' ).fadeIn();
                }
            } );

            magpal_scroll_button.on( "click", function() {
                $( "html, body" ).animate( { scrollTop: 0 }, 300 );
                return false;
            } );
        }
    }

    if(magpal_ajax_object.sticky_header_active){
    if($("#magpal-header-end").length){

    // grab the initial top offset of the navigation 
    var magpalstickyheadertop = $('#magpal-header-end').offset().top;
    
    // our function that decides weather the navigation bar should have "fixed" css position or not.
    var magpalstickyheader = function(){
        var magpalscrolltop = $(window).scrollTop(); // our current vertical position from the top
             
        // if we've scrolled more than the navigation, change its position to fixed to stick to top,
        // otherwise change it back to relative

        if(magpal_ajax_object.sticky_header_mobile_active){
            if (magpalscrolltop > magpalstickyheadertop) {
                $('.magpal-site-header').addClass('magpal-fixed');
            } else {
                $('.magpal-site-header').removeClass('magpal-fixed');
            }
        } else {
            if(window.innerWidth > 1112) {
                if (magpalscrolltop > magpalstickyheadertop) {
                    $('.magpal-site-header').addClass('magpal-fixed');
                } else {
                    $('.magpal-site-header').removeClass('magpal-fixed');
                }
            }
        }
    };

    magpalstickyheader();
    // and run it again every time you scroll
    $(window).on( "scroll", function() {
        magpalstickyheader();
    });

    }
    }

    // init Masonry
    var $magpal_grid = $('.magpal-posts-grid').masonry({
      itemSelector: '.magpal-grid-post',
      columnWidth: magpal_ajax_object.columnwidth,
      gutter: magpal_ajax_object.gutter,
      percentPosition: false,
      transitionDuration: '0.4s',
      fitWidth: true
    });

    // layout Masonry after each image loads
    $magpal_grid.imagesLoaded().progress(function() {
        $magpal_grid.masonry('layout');
    });

    // Recalculate Masonry layout on window resize
    $(window).on('resize', function() {
        $magpal_grid.masonry('layout');
    });

    function magpal_offcanvas_sidebar(options) {
        const { openButtonClass, closeButtonId, sidebarId, overlayClass } = options;

        const openLinks = document.querySelectorAll(`.${openButtonClass}`);
        const closeBtn = document.getElementById(closeButtonId);
        const sidebar = document.getElementById(sidebarId);
        const overlay = document.querySelector(`.${overlayClass}`);
        const html = document.documentElement;
        const body = document.body;
        let lastFocusedElement = null; // Store the last focused open button

        if (!openLinks || !closeBtn || !sidebar || !overlay) {
            //console.error("One or more required elements are missing.");
            return;
        }

        // Open Sidebar
        const openSidebar = function (event) {
            if (event) {
                event.preventDefault(); // Prevent default link behavior
                lastFocusedElement = event.target; // Save the clicked element
            }
            sidebar.classList.add('magpal-sidebar-active');
            overlay.classList.add('magpal-sidebar-active');
            html.classList.add('magpal-sidebar-open');
            body.classList.add('magpal-sidebar-open');

            // Focus Lock Setup
            const focusableElements = 'button, [href], input, select, textarea, [tabindex]:not([tabindex="-1"])';
            const focusableContent = sidebar.querySelectorAll(focusableElements);
            const firstFocusableElement = focusableContent[0];
            const lastFocusableElement = focusableContent[focusableContent.length - 1];

            const handleFocusTrap = function (e) {
                const isTabPressed = e.key === 'Tab' || e.keyCode === 9;

                if (!isTabPressed) return;

                if (e.shiftKey) {
                    // Shift + Tab: Wrap focus to the last element
                    if (document.activeElement === firstFocusableElement) {
                        e.preventDefault();
                        lastFocusableElement.focus();
                    }
                } else {
                    // Tab: Wrap focus to the first element
                    if (document.activeElement === lastFocusableElement) {
                        e.preventDefault();
                        firstFocusableElement.focus();
                    }
                }
            };

            document.addEventListener('keydown', handleFocusTrap);

            // Automatically focus the first focusable element
            if (firstFocusableElement) {
                firstFocusableElement.focus();
            }

            // Close Sidebar and Remove Focus Lock
            const closeSidebarWithCleanup = function () {
                closeSidebar();
                document.removeEventListener('keydown', handleFocusTrap);
            };

            closeBtn.addEventListener('click', closeSidebarWithCleanup, { once: true });
            overlay.addEventListener('click', closeSidebarWithCleanup, { once: true });
        };

        // Close Sidebar
        const closeSidebar = function () {
            sidebar.classList.remove('magpal-sidebar-active');
            overlay.classList.remove('magpal-sidebar-active');
            html.classList.remove('magpal-sidebar-open');
            body.classList.remove('magpal-sidebar-open');

            // Return focus to the last clicked open button
            if (lastFocusedElement) {
                lastFocusedElement.focus();
            }
        };

        // Add Event Listeners to Open Links
        openLinks.forEach(function (link) {
            link.addEventListener('click', openSidebar);
        });
    }

    if(magpal_ajax_object.sidebar_active){
        // Initialize the sidebar with the provided configuration
        magpal_offcanvas_sidebar({
            openButtonClass: 'magpal-open-sidebar-link', // Class of the open sidebar link
            closeButtonId: 'magpal-close-off-canvas',    // ID of the close button
            sidebarId: 'magpal-off-canvas-sidebar',      // ID of the sidebar
            overlayClass: 'magpal-off-canvas-overlay'    // Class of the overlay
        });
    }

});