<?php
/**
* The template for displaying 404 pages (not found).
*
* @link https://codex.wordpress.org/Creating_an_Error_404_Page
*
* @package MagPal WordPress Theme
* @copyright Copyright (C) 2025 ThemesDNA
* @license http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 or later
* @author ThemesDNA <themesdna@gmail.com>
*/

get_header();

// If Elementor is handling the 404.php, exit early (it will load its own content)
if ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'single' ) ) {
    get_footer();
    return;
}
?>

<div id="magpal-404-wrapper" class="magpal-404-wrapper" itemscope="itemscope" itemtype="http://schema.org/Blog" role="main">
    <div class="magpal-outer-wrapper magpal-404-outer-wrapper">
        <div class="magpal-404-wrapper-inside magpal-clearfix">

            <!-- Page Header -->
            <div class="magpal-page-header-outside">
                <header class="magpal-page-header">
                    <div class="magpal-page-header-inside">
                        <h1 class="page-title">
                            <?php echo esc_html( magpal_get_option('error_404_heading') ?: __( 'Oops! That page can not be found.', 'magpal' ) ); ?>
                        </h1>
                    </div>
                </header>
            </div>

            <!-- 404 Content -->
            <div class="magpal-404-content">
                <p>
                    <?php echo wp_kses_post( magpal_get_option('error_404_message') ?: __( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'magpal' ) ); ?>
                </p>
                
                <?php if ( ! magpal_get_option('hide_404_search') ) : ?>
                    <?php get_search_form(); ?>
                <?php endif; ?>
            </div>

            <!-- 404 Widgets -->
            <?php magpal_404_widgets(); ?>

        </div>
    </div>
</div>

<?php get_footer(); ?>