<?php
/**
 * Getting started template
 *
 * @package CreateandCode
 * @subpackage Magnetism
 */

$customizer_url = admin_url() . 'customize.php';
?>

<div id="freepro" class="ccfw-tab-pane">

	<div class="ccfw-tab-pane-center">

		<h1 class="ccfw-welcome-title"><?php esc_html_e( 'Need More? Go PRO', 'magnetism' ); ?></h1>
		<h2><?php esc_html_e( 'Take it to the next level. See the differences below:', 'magnetism' ); ?></h2>

		<table class="free-pro-table">
			<thead>
				<tr>
				<th></th>
				<th><?php esc_html_e( 'Magnetism', 'magnetism' ); ?></th>
				<th><?php esc_html_e( 'Magnetism', 'magnetism' ); ?> <strong><?php esc_html_e( 'PRO', 'magnetism' ); ?></strong></th>
				</tr>
			</thead>

			<tbody>
				<tr>
					<td>
						<h3><?php esc_html_e( 'Beautiful Design', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'We have been designing websites professionally for over 15 years. We understand clean, modern design with gorgeous typography and stylish details and bring it to each theme we create.', 'magnetism' ); ?></p>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				<tr>
					<td>
						<h3><?php esc_html_e( 'Mobile-Ready and Responsive for All Devices', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'From the outset, we have built the theme with mobile devices in mind – it looks fantastic and is quick to navigate on both tablets and phones. Your website deserves to be seen on every kind of device and we’ve ensured that’s the case.', 'magnetism' ); ?></p>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				<tr>
					<td>
						<h3><?php esc_html_e( 'Social Integration and Sticky Menu', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'The top menu includes a theme option allowing it to stick at the top so that it is always available to the user when scrolling. Plus, with a social menu you can easily include links to your social media profiles.', 'magnetism' ); ?></p>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				<tr>
					<td>
						<h3><?php esc_html_e( 'Personalize to Match Your Style - includes both Grid and List Layouts', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'In the Pro version you get far more options to tweak the styling including changing the main navigation layout colors, adjusting the layout, switching on/off sidebars, and tweaking each typography selector such as headings, paragraphs and body copy. Get ultimate control with Pro!', 'magnetism' ); ?></p>
					</td>
					<td class="only-pro">
						<span class="dashicons-before dashicons-no-alt"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				<tr>
					<td>
						<h3><?php esc_html_e( 'Featured Posts Carousel', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'Showcase the latest posts from a category on your homepage, with the Pro version you have a number of extra style options to display your featured posts, including a slider or carousel.', 'magnetism' ); ?></p>
					</td>
					<td class="only-pro">
						<span class="dashicons-before dashicons-no-alt"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				<tr>
					<td>
						<h3><?php esc_html_e( 'WooCommerce Integration', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'We have added a beautiful WooCommerce integration to the Pro version, meaning you can sell items with your very own store. Powering nearly 30% of online shops, WooCommerce gives you an unrivalled feature set to begin selling online.', 'magnetism' ); ?></p>
					</td>
					<td class="only-pro">
						<span class="dashicons-before dashicons-no-alt"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				<tr>
					<td>
						<h3><?php esc_html_e( 'Reviews Post Type', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'The Pro version includes a new Review post type. Easily add reviews of products and add your own criteria for the rating. You can even include an affiliate link with the review for monetizing your blog. All of which is 100% schema compliant, to ensure your articles are indexed as reviews when searching on Google.', 'magnetism' ); ?></p>
					</td>
					<td class="only-pro">
						<span class="dashicons-before dashicons-no-alt"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				<tr>
					<td>
						<h3><?php esc_html_e( 'Instagram Footer', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'In the Pro version you will be able to easily drop in an Instagram row next to your footer to show off your brand and to keep your site looking as fresh as the photos you take.', 'magnetism' ); ?></p>
					</td>
					<td class="only-pro">
						<span class="dashicons-before dashicons-no-alt"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				<tr>
					<td>
						<h3><?php esc_html_e( 'No Credit Footer Link', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'Remove or edit the "Proudly powered by WordPress Theme: Magnetism by Create and Code" copyright notice from the footer area.', 'magnetism' ); ?></p>
					</td>
					<td class="only-pro">
						<span class="dashicons-before dashicons-no-alt"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				<tr>
					<td>
						<h3><?php esc_html_e( 'Fantastic Support', 'magnetism' ); ?></h3>
						<p><?php esc_html_e( 'Our Pro customers receive access to world-class customer support from the actual people who have built the themes. We reply to tickets speedily and efficiently - you will be in very good hands if you have any questions.', 'magnetism' ); ?></p>
					</td>
					<td class="only-pro">
						<span class="dashicons-before dashicons-no-alt"></span>
					</td>
					<td class="only-lite">
						<span class="dashicons-before dashicons-yes"></span>
					</td>
				</tr>

				</tbody>

				</table>

				<div class="ccfw-theme-discount">
				<p><?php _e( 'As a special thank you for being a Magnetism user you can get a <strong>whopping 30% off</strong> if you upgrade to Magnetism Pro today with the code <strong>CCTHEME30</strong>. Get all the Pro features, ongoing updates and superb customer support!', 'magnetism' ); ?></p>
				<a class="button-primary" href="<?php echo esc_url( 'https://createandcode.com/wordpress-themes/magnetism-pro/' ); ?>"><?php esc_html_e( 'Get Magnetism Pro', 'magnetism' ); ?> &rarr;</a>
				</div>

	</div>

	<div class="ccfw-clear"></div>

</div>
