<?php
if (class_exists('MagazineNP_Widget_Base')) {
	class Magazineplus_Tab extends MagazineNP_Widget_Base
	{

		function __construct()
		{
			$widget_ops = array(
				'classname' => 'magazineplus-tabs-widget',
				'description' => __('Tabs', 'magazineplus')
			);
			parent::__construct(false, $name = __('MNP::Tab Widget', 'magazineplus'), $widget_ops);
		}

		function widget_fields()
		{

			$fields = array(
				'widget_title' => array(
					'name' => 'widget_title',
					'title' => esc_html__('Title', 'magazineplus'),
					'type' => 'text',
					'default' => esc_html__('Tab Widget', 'magazineplus'),

				),
				'popular_label' => array(
					'name' => 'popular_label',
					'title' => esc_html__('Popular Posts Title', 'magazineplus'),
					'type' => 'text',
					'default' => esc_html__('Popular Posts', 'magazineplus'),

				),
				'recent_label' => array(
					'name' => 'recent_label',
					'title' => esc_html__('Recent Posts Title', 'magazineplus'),
					'type' => 'text',
					'default' => esc_html__('Recent Posts', 'magazineplus'),

				),
				'comment_label' => array(
					'name' => 'comment_label',
					'title' => esc_html__('Comments Title', 'magazineplus'),
					'type' => 'text',
					'default' => esc_html__('Comments', 'magazineplus'),

				),
				'number_of_posts' => array(
					'name' => 'number_of_posts',
					'title' => esc_html__('Number of posts', 'magazineplus'),
					'type' => 'number',
					'default' => 2,

				),


			);

			return $fields;
		}

		function widget($args, $instance_arg)
		{
			$instance = MagazineNP_Widget_Validation::instance()->validate($instance_arg, $this->widget_fields());

			echo $args['before_widget']; ?>
			<?php if (!empty($instance['widget_title'])) {
			echo $args['before_title'] . $instance['widget_title'] . $args['after_title'];
		} ?>
			<div class="magazineplus-tab-widget">
				<ul class="widget-tabs">
					<li class="tabs popular-tabs"><a
							href="#popular"><i
								class="fa fa-star"></i><?php echo esc_html($instance['popular_label']); ?>
						</a>
					</li>
					<li class="tabs recent-tabs"><a
							href="#recent"><i
								class="fa fa-history"></i><?php echo esc_html($instance['recent_label']); ?>
						</a>
					</li>
					<li class="tabs comment-tabs"><a
							href="#comment"><i
								class="fa fa-comment"></i><?php echo esc_html($instance['comment_label']); ?></a>
					</li>
				</ul>

				<div class="tabbed-widget-popular" id="popular">
					<?php
					global $post;

					$magazineplus_query_args = array();

					$magazineplus_query_args = array(
						'posts_per_page' => absint($instance['number_of_posts']),
						'post_type' => 'post',
						'ignore_sticky_posts' => true,
						'orderby' => 'comment_count',
						'no_found_rows' => true
					);
					$get_featured_posts = new WP_Query($magazineplus_query_args);
					?>
					<?php $featured = 'newsmagaezine-tab-thumbnail'; ?>
					<?php
					$i = 1;
					while ($get_featured_posts->have_posts()):$get_featured_posts->the_post();
						?>
						<div class="single-article clearfix">
							<div class="mnp-post-boxed inlined clearfix">
								<?php if (has_post_thumbnail()) { ?>
									<div class="mnp-post-image-wrap">
										<a href="<?php the_permalink(); ?>" class="mnp-post-image"
										   style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>');"></a>
									</div>
								<?php } ?>
								<div class="post-content">

									<?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '">', '</a></h3>'); ?>

									<div class="entry-meta">
										<?php magazinenp_posted_on(); ?>
									</div>


								</div>
							</div><!-- mnp-post-boxed -->

						</div>
						<?php
						$i++;
					endwhile;
					// Reset Post Data
					wp_reset_query();
					?>
				</div>

				<div class="tabbed-widget-recent" id="recent">
					<?php
					global $post;

					$get_featured_posts = new WP_Query(array(
						'posts_per_page' => absint($instance['number_of_posts']),
						'post_type' => 'post',
						'ignore_sticky_posts' => true,
						'no_found_rows' => true
					));
					?>
					<?php $featured = 'newsmagaezine-tab-thumbnail'; ?>
					<?php
					$i = 1;
					while ($get_featured_posts->have_posts()):$get_featured_posts->the_post();
						?>
						<div class="single-article clearfix">
							<div class="mnp-post-boxed inlined clearfix">
								<?php if (has_post_thumbnail()) { ?>
									<div class="mnp-post-image-wrap">
										<a href="<?php the_permalink(); ?>" class="mnp-post-image"
										   style="background-image: url('<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>');"></a>
									</div>
								<?php } ?>
								<div class="post-content">

									<?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '">', '</a></h3>'); ?>

									<div class="entry-meta">
										<?php magazinenp_posted_on(); ?>
									</div>


								</div>
							</div><!-- mnp-post-boxed -->

						</div>
						<?php
						$i++;
					endwhile;
					// Reset Post Data
					wp_reset_query();
					?>
				</div>

				<div class="tabbed-widget-comment" id="comment">
					<?php
					$comments_query = new WP_Comment_Query();
					$comments = $comments_query->query(array(
						'number' => absint($instance['number_of_posts']),
						'status' => 'approve'
					));
					$commented = '';
					if ($comments) : foreach ($comments as $comment) :
						$commented .= '<li class="tabbed-comment-widget">';
						$commented .= '<a class="author-thumbnail" href="' . get_permalink($comment->comment_post_ID) . '#comment-' . $comment->comment_ID . '">';
						$commented .= get_avatar($comment->comment_author_email, '50');
						$commented .= '</a>';
						$commented .= '<div class="comment-wraper">';
						$commented .= '<a class="author-nicename" href="' . get_permalink($comment->comment_post_ID) . '#comment-' . $comment->comment_ID . '">';
						$commented .= get_comment_author($comment->comment_ID);
						$commented .= '</a>' . ' ' . esc_html__('says:', 'magazineplus');
						$commented .= '<p class="commented">' . strip_tags(substr(apply_filters('get_comment_text', $comment->comment_content), 0, '50')) . '...</p>';
						$commented .= '</div>';
						$commented .= '</li>';
					endforeach;
					else :
						$commented .= esc_html__('No comments', 'magazineplus');
					endif;
					echo $commented;
					?>
				</div>

			</div>
			<?php

			echo $args['after_widget'] . '<!-- .widget_featured_post -->';
		}
	}
}
