<?php

define('MAGAZINEPLUS_VERSION', '1.0.7');

//Tab Widget
add_action('magazinenp_include_widgets', 'magazineplus_include_widgets');
add_action('magazinenp_init_widgets', 'magazineplus_init_widgets');

function magazineplus_include_widgets()
{
	require get_stylesheet_directory() . '/inc/widgets/tabs.php'; //Tab Widgets
}

function magazineplus_init_widgets()
{
	if (class_exists('Magazineplus_Tab')) {
		register_widget('Magazineplus_Tab');
	}

}

function magazineplus_scripts()
{

	wp_register_script('magazineplus-easytabs', get_stylesheet_directory_uri() . '/assets/vendor/easy-tabs/jquery.easytabs.js', array(), esc_attr(MAGAZINEPLUS_VERSION), true);
	wp_enqueue_script('magazineplus-script-main', get_stylesheet_directory_uri() . '/assets/js/main.js', array('magazineplus-easytabs'), esc_attr(MAGAZINEPLUS_VERSION), true);

	if (is_rtl()) {

		wp_enqueue_style('magazineplus-rtl-main', get_template_directory_uri() . '/rtl.css', array(), esc_attr(MAGAZINEPLUS_VERSION));

	}

}

add_action('wp_enqueue_scripts', 'magazineplus_scripts', 20);

if (!function_exists('magazineplus_setup')) :

	function magazineplus_setup()
	{


		add_image_size('magazineplus-tab-thumbnail', 136, 102, true);
		/*
		   * Enable support for Post Thumbnails on posts and pages.
		   *
		   * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		   */
		add_theme_support('post-thumbnails');

		/**
		 * Loads the child theme textdomain.
		 */
		load_child_theme_textdomain('magazineplus', get_stylesheet_directory() . '/languages');

	}

endif;
add_action('after_setup_theme', 'magazineplus_setup');
