<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 7.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

wc_print_notices();

?>
<div class="lyrMyAccount">
	<?php if ( 'no' === get_option( 'woocommerce_enable_myaccount_registration' ) ) { ?>
    <div class="woocommerce-MyAccount-content">
        <div class="wc-MyAccount-sub-heading">
            <h2><?php esc_html_e( 'Login', 'lyrielle' ); ?></h2>
        </div>

		<?php } ?>
		<?php

		do_action( 'woocommerce_before_customer_login_form' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

		<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

        <div class="u-columns col2-set" id="customer_login">

            <div class="u-column1 col-1">

				<?php endif; ?>
                <div class="lyr-customer-login">

                    <form class="woocommerce-form woocommerce-form-login login" method="post">

						<?php do_action( 'woocommerce_login_form_start' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

                        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                            <label for="username"><?php esc_html_e( 'Username or email address', 'lyrielle' ); ?>&nbsp;<span class="required">*</span></label>
                            <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
                        </p>
                        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                            <label for="password"><?php esc_html_e( 'Password', 'lyrielle' ); ?>&nbsp;<span class="required">*</span></label>
                            <input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" />
                        </p>

						<?php do_action( 'woocommerce_login_form' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

                        <p class="woocommerce-LostPassword lost_password">
                            <input class="woocommerce-form__input woocommerce-form__input-checkbox lyr-styled-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" />
                            <label class="woocommerce-form__label woocommerce-form__label-for-checkbox inline" for="rememberme"><?php esc_html_e( 'Remember me', 'lyrielle' ); ?></label>
                            <a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'lyrielle' ); ?></a>
                        </p>
                        <p class="form-row woocommerce-LoginBtn">
							<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
                            <button type="submit" class="woocommerce-Button button" name="login" value="<?php esc_attr_e( 'Login', 'lyrielle' ); ?>"><?php esc_html_e( 'Login', 'lyrielle' ); ?></button>
                        </p>

						<?php do_action( 'woocommerce_login_form_end' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>
                    </form>
                </div>

				<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

            </div>

            <div class="u-column2 col-2">
                <div class="lyr-customer-register">
                    <h2><?php esc_html_e( 'Register', 'lyrielle' ); ?></h2>

                    <form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action( 'woocommerce_register_form_tag' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?> >

						<?php do_action( 'woocommerce_register_form_start' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

						<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

                            <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                                <label for="reg_username"><?php esc_html_e( 'Username', 'lyrielle' ); ?>&nbsp;<span class="required">*</span></label>
                                <input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
                            </p>

						<?php endif; ?>

                        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                            <label for="reg_email"><?php esc_html_e( 'Email address', 'lyrielle' ); ?>&nbsp;<span class="required">*</span></label>
                            <input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
                        </p>

						<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

                            <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                                <label for="reg_password"><?php esc_html_e( 'Password', 'lyrielle' ); ?>&nbsp;<span class="required">*</span></label>
                                <input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" />
                            </p>

						<?php else : ?>

                            <p><?php esc_html_e( 'A password will be sent to your email address.', 'lyrielle' ); ?></p>

						<?php endif; ?>

						<?php do_action( 'woocommerce_register_form' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

                        <p class="woocommerce-FormRow form-row woocommerce-RegisterBtn">
							<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
                            <button type="submit" class="woocommerce-Button woocommerce-button button woocommerce-form-register__submit" name="register" value="<?php esc_attr_e( 'Register', 'lyrielle' ); ?>"><?php esc_html_e( 'Register', 'lyrielle' ); ?></button>
                        </p>

						<?php do_action( 'woocommerce_register_form_end' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

                    </form>
                </div>

            </div>

        </div>
	<?php endif; ?>

		<?php do_action( 'woocommerce_after_customer_login_form' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

		<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'no' ) : ?>
    </div> <?php // woocommerce-MyAccount-content ?>
<?php endif; ?>

</div>
