<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<div class="MyAccount-content--dashboard">
    <div class="wc-MyAccount-sub-heading">
        <h2>
        <?php
        printf( /* Translators: %s: name */
    		__( 'Hello %1$s', 'lyrielle' ), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    		'<strong>' . esc_html( $current_user->display_name ) . '</strong>',
    		esc_url( wc_logout_url( wc_get_page_permalink( 'myaccount' ) ) )
    	);
        ?>
        </h2>
        <p>
        <?php
        printf( /* Translators: %1$s: name, %2$s: link */
    		__( 'not %1$s? <a href="%2$s">Log out</a>', 'lyrielle' ), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
    		esc_html( $current_user->display_name ),
    		esc_url( wc_logout_url( wc_get_page_permalink( 'myaccount' ) ) )
    	);
        ?>
        </p>

        <p>
            <?php
		    printf( /* Translators: %1$s: link to recent orders, %2$s: link to shipping and billing addresses, %3$s link to edit your password and account details */
			    __( 'From your account dashboard you can view your <a href="%1$s">recent orders</a>, manage your <a href="%2$s">shipping and billing addresses</a>, and <a href="%3$s">edit your password and account details</a>.', 'lyrielle' ), // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			    esc_url( wc_get_endpoint_url( 'orders' ) ),
			    esc_url( wc_get_endpoint_url( 'edit-address' ) ),
			    esc_url( wc_get_endpoint_url( 'edit-account' ) )
		    );
		    ?>
        </p>
    </div>
    <div class="wc-MyAccount-inner-content">

        <div class="wc-MyAccount-dashboard-block">
        <?php

        $my_orders_columns = apply_filters( // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
			'woocommerce_my_account_my_orders_columns', array( // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
				'order-number'  => __( 'Order', 'lyrielle' ),
				'order-date'    => __( 'Date', 'lyrielle' ),
				'order-status'  => __( 'Status', 'lyrielle' ),
				'order-total'   => __( 'Total', 'lyrielle' ),
				'order-actions' => __( 'Actions', 'lyrielle' ),
			)
		);

        $customer_orders = get_posts( apply_filters( // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
			'woocommerce_my_account_my_orders_query', array( // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
				'numberposts' => 3,
				'meta_key'    => '_customer_user',
				'meta_value'  => get_current_user_id(),
				'post_type'   => wc_get_order_types( 'view-orders' ),
				'post_status' => array_keys( wc_get_order_statuses() ),
        	)
		) );

        if ( $customer_orders ) : ?>
            <div class="wc-MyAccount-sub-heading">
                <h2><?php echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					'woocommerce_my_account_my_orders_title', __( 'Recent orders', 'lyrielle' ) // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
					); ?>
				</h2>
            </div>

            <div class="wc-MyAccount-inner-content">
            	<table class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table account-orders-table-dashboard">

            		<thead>
            			<tr>
            				<?php // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
								foreach ( $my_orders_columns as $column_id => $column_name ) : // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound ?>
            					<th class="<?php echo esc_attr( $column_id ); ?>"><span class="nobr"><?php echo esc_html( $column_name ); ?></span></th>
            				<?php
								endforeach;
							?>
            			</tr>
            		</thead>

            		<tbody>
            			<?php
                            $i = 0; // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
                            foreach ( $customer_orders as $customer_order ) : // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
                            if($i >= 3) {
                                break;
                            } else {
            				$order      = wc_get_order( $customer_order ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
            				$item_count = $order->get_item_count(); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
            				?>
            				<tr class="order">
            					<?php  // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
									foreach ( $my_orders_columns as $column_id => $column_name ) : // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound ?>
            						<td class="<?php echo esc_attr( $column_id ); ?>" data-title="<?php echo esc_attr( $column_name ); ?>">
            							<?php // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
											if ( has_action( 'woocommerce_my_account_my_orders_column_' . $column_id ) ) : // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>
            								<?php do_action( 'woocommerce_my_account_my_orders_column_' . $column_id, $order ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

            							<?php elseif ( 'order-number' === $column_id ) : ?>
            								<span>
            									<?php echo _x( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
													'#', 'hash before order number', 'lyrielle' ) . $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
												?>
            								</span>

            							<?php elseif ( 'order-date' === $column_id ) : ?>
            								<time datetime="<?php echo esc_attr( $order->get_date_created()->date( 'c' ) ); ?>"><?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?></time>

            							<?php elseif ( 'order-status' === $column_id ) : ?>
            								<?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?>

            							<?php elseif ( 'order-total' === $column_id ) : ?>
            								<?php
            								/* translators: 1: formatted order total 2: total order items */
            								printf( _n( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
												'%1$s for %2$s item', '%1$s for %2$s items', $item_count, 'lyrielle' ), $order->get_formatted_order_total(), $item_count // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
											);
            								?>

            							<?php elseif ( 'order-actions' === $column_id ) : ?>
            								<?php
            								$actions = wc_get_account_orders_actions( $order ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound

            								if ( ! empty( $actions ) ) {
            									foreach ( $actions
													as $key // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
													=>
													$action ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
            										echo '<a href="' . esc_url( $action['url'] ) . '" class="button ' . sanitize_html_class( $key ) . '">' . esc_html( $action['name'] ) . '</a>';
            									}
            								}
            								?>
            							<?php endif; ?>
            						</td>
            					<?php
									endforeach;
								?>
            				</tr>
            			<?php
                        $i++;
                        }
                        ?>
                        <?php endforeach; ?>
            		</tbody>
            	</table>
            </div>
        <?php endif; ?>
        </div>

        <?php
        $customer_id = get_current_user_id(); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
        $user = get_userdata( $customer_id ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound

        if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
        	$get_addresses = apply_filters( // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
				'woocommerce_my_account_get_addresses', array( // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
					'billing' => __( 'Billing address', 'lyrielle' ),
					'shipping' => __( 'Shipping address', 'lyrielle' ),
				),
				$customer_id
			);
        } else {
        	$get_addresses = apply_filters( // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
				'woocommerce_my_account_get_addresses', array( // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
        			'billing' => __( 'Billing address', 'lyrielle' ),
        		),
			$customer_id
			);
        }

        $oldcol = 1; // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
        $col    = 1; // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
        ?>
        <div class="wc-DashBoard-address-wrapper">
            <?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) : ?>
            	<div class="u-columns woocommerce-Addresses col2-set addresses">
            <?php endif; ?>

            <?php foreach ( $get_addresses // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
					as $name // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
					=>
					$title ) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited ?>

            	<div class="u-column<?php // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
					echo ( ( $col = $col * -1 ) < 0 ) ? 1 : 2; ?> col-<?php echo ( ( $oldcol = $oldcol * -1 ) < 0 ) ? 1 : 2; // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
					?> woocommerce-Address">
            		<header class="woocommerce-Address-title title">
            			<h3><?php echo $title; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></h3>
                        <a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', $name ) ); ?>" class="edit"><?php esc_html_e( 'Edit', 'lyrielle' ); ?></a>
            		</header>
            		<address><?php
            			$address = wc_get_account_formatted_address( $name ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
            			echo $address ? wp_kses_post( $address ) : esc_html_e( 'You have not set up this type of address yet.', 'lyrielle' );
            		?></address>
            	</div>

            <?php endforeach; ?>

            <?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) : ?>
            	</div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
