<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 8.1.0
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="woocommerce-order">

	<?php
	if ( $order ) :

		do_action( 'woocommerce_before_thankyou', $order->get_id() ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

        <div class="woocommerce-order-over">

		<?php if ( $order->has_status( 'failed' ) ) : ?>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'lyrielle' ); ?></p>

			<p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
				<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php esc_html( 'Pay', 'lyrielle' ) ?></a>
				<?php if ( is_user_logged_in() ) : ?>
					<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php esc_html( 'My account', 'lyrielle' ); ?></a>
				<?php endif; ?>
			</p>

		<?php else : ?>

                <h2 class="woocommerce-heading--success woocommerce-thankyou-order-received-heading"><i class="lyr-icon-check"></i><?php esc_html( 'Your Order Confirmed', 'lyrielle' ); ?></h2>

    			<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					'woocommerce_thankyou_order_received_text', __( 'Thank you. Your order has been received.', 'lyrielle' ), $order // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
					); ?>
				</p>

    			<ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">

    				<li class="woocommerce-order-overview__order order">
    					<?php esc_html( 'Order number:', 'lyrielle' ); ?>
    					<span><?php echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></span>
    				</li>

    				<li class="woocommerce-order-overview__date date">
    					<?php esc_html( 'Date:', 'lyrielle' ); ?>
    					<span><?php echo wc_format_datetime( $order->get_date_created() ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></span>
    				</li>

    				<?php if ( is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email() ) : ?>
    					<li class="woocommerce-order-overview__email email">
    						<?php esc_html( 'Email:', 'lyrielle' ); ?>
    						<span><?php echo $order->get_billing_email(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></span>
    					</li>
    				<?php endif; ?>

    				<li class="woocommerce-order-overview__total total">
    					<?php esc_html( 'Total:', 'lyrielle' ); ?>
    					<span><?php echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></span>
    				</li>

    				<?php if ( $order->get_payment_method_title() ) : ?>
    					<li class="woocommerce-order-overview__payment-method method">
    						<?php esc_html( 'Payment method:', 'lyrielle' ); ?>
    						<span><?php echo wp_kses_post( $order->get_payment_method_title() ); ?></span>
    					</li>
    				<?php endif; ?>

    			</ul>

		<?php endif; ?>

		<?php do_action( 'woocommerce_thankyou_' . $order->get_payment_method(), $order->get_id() ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>
        </div>
		<?php do_action( 'woocommerce_thankyou', $order->get_id() ); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound ?>

	<?php else : ?>

		<p class="woocommerce-notice woocommerce-notice--success woocommerce-thankyou-order-received"><?php echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			'woocommerce_thankyou_order_received_text', esc_html__( 'Thank you. Your order has been received.', 'lyrielle' ), null // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedHooknameFound
			); ?>
		</p>

	<?php endif; ?>

</div>

<div class="woocommerce-order-end">
    <h3 class="woocommerce-heading--end"><?php esc_html( 'Thank you for shopping with us!', 'lyrielle' ); ?></h3>
</div>
