<?php
/**
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Lyrielle
 */

require get_template_directory() . '/inc/social_media_names.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
require get_template_directory() . '/inc/social_media_icons.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound

$html_social_media_links = '';

foreach ( $lyrielle_social_media_names as $social_media_key => $social_media_name ) {
	$social_media_url = get_theme_mod( 'lyrielle_social_' . $social_media_key, '#' );

	if ( $social_media_url && '#' !== str_replace( ' ', '', $social_media_url ) ) {
		$html_social_media_links .= sprintf(
			'<a href="%s" class="social-link" target="_blank">',
			esc_url( $social_media_url )
		);
		$html_social_media_links .= sprintf(
			'<i class="fab %s"></i>',
			esc_attr( $lyrielle_social_media_icons[ $social_media_key ] )
		);
		$html_social_media_links .= sprintf(
			'<span class="label-name">%s</span>',
			esc_attr( $social_media_name )
		);
		$html_social_media_links .= ('</a>');
	}
}

if ( $html_social_media_links ) : ?>
<li><?php echo $html_social_media_links; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></li>
<?php endif;
