<?php

$mobile_menu = 'menu-mobile';

// Fallback to main menu for AMP if mobile is missing
if ( ! has_nav_menu( 'menu-mobile' ) ) {
	$mobile_menu = 'menu-primary';
}

?>

<div class="mobile-menu-container" id="mobile-menu">
	<button type="button" id="mobile-close-menu-button" class="menu-toggle close" aria-controls="primary-menu" aria-expanded="false" aria-label="close navigation">></button>
	<?php if ( has_nav_menu( $mobile_menu ) ): ?>

		<?php
		wp_nav_menu( array(
			'container'      => '',
			'menu_class'     => 'mobile-menu',
			'theme_location' => $mobile_menu,
			'items_wrap'     => '<ul id="primary-menu" class="%2$s">%3$s</ul>',
		) );
		?>

	<?php else: ?>

		<ul class="mobile-menu">
			<?php
			wp_nav_menu( array(
				'container'      => '',
				'menu_class'     => 'primary-mobile-menu',
				'theme_location' => $mobile_menu,
				'items_wrap'     => '<ul id="primary-menu" class="%2$s">%3$s</ul>',
			) );
			?>
		</ul>

	<?php endif;?>
</div>
