<?php
/**
 * The template for displaying the footer in footer.php
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Lyrielle
 */
?>

<?php if ( is_active_sidebar( 'lyrielle-footer' ) ): ?>
<div class="footer-widget-area widget-area">
	<div class="container">
		<ul class="widget">
			<?php dynamic_sidebar( 'lyrielle-footer' ); ?>
		</ul>
	</div>
</div>
<?php endif;?>

<div class="site-info">
	<div class="container">
		<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'lyrielle' ) ); ?>">
		<?php
		/* translators: %s: CMS name, i.e. WordPress. */
		printf( esc_html__( 'Proudly powered by %s', 'lyrielle' ), 'WordPress' );
		?>
		</a>
		<span class="sep"> | </span>
		<?php
		/* translators: 1: Theme name, 2: Theme author. */
		printf( esc_html__( 'Copyright © 2024 %1$s Themes ®', 'lyrielle' ), 'Lyrielle' );
		?>
		<span class="sep"> | </span>
		<?php
		/* translators: 1: Theme name. */
		printf( esc_html__( 'Theme: %1$s', 'lyrielle' ), 'Lyrielle' );
		?>
	</div>
</div><!-- .site-info -->
