<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Lyrielle
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if ( is_front_page() ) : ?>

	<header class="entry-header">
		<div class="entry-info">
			<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
		</div>
		
		<div class="entry-thumbnail">
			<?php 
			if ( has_post_thumbnail() ) {
				lyrielle_post_thumbnail(); 
			}
			?>
		</div>

	</header><!-- .entry-header -->
	<div class="entry-secondary-info">
		<?php
		// Create an instance of the widget class
		$widget = new lyrielle_Popular_Category_Posts_Widget();
		
		// Call the widget's method to get and display the popular posts
		echo $widget->get_popular_category_posts( array(
			'title' => 'Top Trending',
			'count' => 4
		) );
		?>
	</div>

	<?php else : ?>

	<header class="entry-header">
		<?php
		if ( has_post_thumbnail() ) {
			lyrielle_post_thumbnail(); 
		} ?>
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
	</header><!-- .entry-header -->

	<?php endif; ?>

	<div class="entry-content">
		<?php
		the_content();

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'lyrielle' ),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->

	<?php if ( get_edit_post_link() ) : ?>
		<footer class="entry-footer">
			<?php
			edit_post_link(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Edit <span class="screen-reader-text">%s</span>', 'lyrielle' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post( get_the_title() )
				),
				'<span class="edit-link">',
				'</span>'
			);
			?>
		</footer><!-- .entry-footer -->
	<?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->
