<?php
/**
 * Template part for displaying archive
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Lyrielle
 */

?>

<article id="post-<?php the_ID(); ?>"<?php post_class( 'lyr-archive' ); ?>>
	<div class="title title-archive">
		<?php
			the_archive_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark" class="archive-title">', '</a></h2>' );
		?>
	</div>
	<div class="entry-thumb">
		<?php if ( has_post_thumbnail() ) : ?>
		<a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="0">
			<?php
			the_post_thumbnail( 'post-thumbnail', array(
				'alt' => the_title_attribute( array(
					'echo' => false,
				) ),
			) );
			?>
		</a>
		<?php endif; ?>
		
		<div class="entry-content entry-archive-content">
			<div class="entry-meta">
				<?php if ( 'post' === get_post_type() ) : ?>
					<?php
						lyrielle_posted_on();
						lyrielle_posted_by();
						lyrielle_post_tag_links();
						lyrielle_post_category_links();
					?>
				<?php endif; ?>
			</div>
	
			<div class="entry-post">
				<?php
				if ( get_option( 'rss_use_excerpt' ) ) {
					the_excerpt( sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'lyrielle' ),
							array(
								'span' => array( 'class' => array(), ),
							)
						),
						get_the_title()
					) );
				?>
				<a class="read-more" href="<?php the_permalink() ?>" title="<?php the_title(); ?>"><?php esc_html_e( 'Read More', 'lyrielle' ); ?><span>&#8250;</span></a>
				<?php
				} else {
					the_content();
				}
	
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'lyrielle' ),
					'after'  => '</div>',
				) );
				?>
			</div><!-- .entry-post -->
		</div>
	</div>

	<footer class="entry-footer">
		<?php lyrielle_entry_footer(); ?>
	</footer><!-- .entry-footer -->

</article><!-- #post-<?php the_ID(); ?> -->
