<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Lyrielle
 */

get_header();
?>

	<main id="primary" class="site-main container">
		<div class="main-wrap">
			<div class="main-content">
				<?php
				while ( have_posts() ) :
					the_post();

					get_template_part( 'template-parts/content/content', get_post_type() );
					?>
						<div class="author-box">
							<div class="image"><?php echo get_avatar( get_the_author_meta('user_email'), 82 ); ?></div>

							<div class="content">
								<span class="author">
									<span><?php esc_html_e('Author', 'lyrielle'); ?></span>
									<?php the_author_posts_link(); ?>
								</span>
							</div>

						</div>
						<?php
						the_post_navigation(
							array(
								'prev_text' => '<span class="nav-icon"><i class="fa-solid fa-angle-left"></i></i></span> <span class="nav-title">%title</span>',
								'next_text' => '<span class="nav-title">%title</span> <span class="nav-icon"><i class="fa-solid fa-angle-right"></i></i></span>',
							)
						);
						// If comments are open or we have at least one comment, load up the comment template.
						if ( comments_open() || get_comments_number() ) :
							comments_template();
						endif;
				endwhile; // End of the loop.
				?>
			</div>

			<?php get_sidebar(); ?>
		</div>


	</main><!-- #main -->

<?php
get_footer();
