<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Lyrielle
 */

get_header();
?>

<main id="primary" class="site-main container">

<?php if ( have_posts() ) : ?>

	<header class="search-header">
	<h1 class="title"><?php /* Translators: %s: search result name */
		printf( esc_html__( 'Search Results for: %s', 'lyrielle' ), '<span>' . get_search_query() . '</span>' );
		?>
	</h1>
	<span class="search-background"><?php echo esc_html( esc_html__(  'search', 'lyrielle' ) ); ?></span>
	</header><!-- .page-header -->

	<div class="main-wrap">
		<div class="main-content">
			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/*
				* Include the Post-Type-specific template for the content.
				* If you want to override this in a child theme, then include a file
				* called content-___.php (where ___ is the Post Type name) and that will be used instead.
				*/
				get_template_part( 'template-parts/content/content', 'search' );

			endwhile;

			the_posts_navigation(
				array(
					'prev_text' => '<span class="nav-icon"><i class="fa-solid fa-angle-left"></i></i></span> <span class="nav-title">Older posts</span>',
					'next_text' => '<span class="nav-title">Newer posts</span> <span class="nav-icon"><i class="fa-solid fa-angle-right"></i></i></span>',
				)
			);

		else :

			get_template_part( 'template-parts/content/content', 'none' );

		endif;
		?>
		</div>

	</div>

</main><!-- #main -->

<?php
get_footer();
