<?php
/**
 * Title: Intro - Hero with Additional Content
 * Slug: lyrielle/lyr-intro-with-additional-content
 * Categories: lyrielle-patterns
 * Description: A hero section with a call-to-action and an additional content block beneath it.
 * Viewport Width: 1200
 */
?>
<!-- wp:group {"align":"full","className":"custom-cover-with-block"} -->
<div class="wp-block-group alignfull custom-cover-with-block">
    <!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() . '/assets/images/default-block-image.jpg' ); ?>","dimRatio":50,"isUserOverlayColor":false,"focalPoint":{"x":0.5,"y":0.5},"contentPosition":"center center"} -->
    <div class="wp-block-cover">
        <span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span>
        <img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/default-block-image.jpg' ); ?>" style="object-position:50% 50%" data-object-fit="cover" data-object-position="50% 50%" />
        <div class="wp-block-cover__inner-container">
            <!-- wp:spacer {"height":"var:preset|spacing|60"} -->
            <div style="height:var(--wp--preset--spacing--60)" aria-hidden="true" class="wp-block-spacer"></div>
            <!-- /wp:spacer -->

            <!-- wp:group -->
            <div class="wp-block-group">
                <!-- wp:heading {"textAlign":"center","level":1,"style":{"color":{"text":"#ffffff"}},"fontSize":"x-large"} -->
                <h1 class="wp-block-heading has-text-align-center has-text-color has-x-large-font-size" style="color:#ffffff">Welcome to Lyrielle</h1>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center","style":{"color":{"text":"#ffffff"}}} -->
                <p class="has-text-align-center has-text-color" style="color:#ffffff">Create beautiful websites with ease.</p>
                <!-- /wp:paragraph -->

                <!-- wp:spacer {"height":"var:preset|spacing|20"} -->
                <div style="height:var(--wp--preset--spacing--20)" aria-hidden="true" class="wp-block-spacer"></div>
                <!-- /wp:spacer -->

                <!-- wp:buttons {"align":"center"} -->
                <div class="wp-block-buttons is-content-justification-center">
                    <!-- wp:button {"backgroundColor":"primary"} -->
                    <div class="wp-block-button"><a class="wp-block-button__link has-primary-background-color has-background wp-element-button">Get Started</a></div>
                    <!-- /wp:button -->
                </div>
                <!-- /wp:buttons -->

            </div>
            <!-- /wp:group -->

            <!-- wp:spacer {"height":"var:preset|spacing|60"} -->
            <div style="height:var(--wp--preset--spacing--60)" aria-hidden="true" class="wp-block-spacer"></div>
            <!-- /wp:spacer -->

            <!-- wp:group {"className":"custom-under-block"} -->
            <div class="wp-block-group custom-under-block">
                <div class="wp-block-group__inner-container">
                    <!-- wp:spacer {"height":"var:preset|spacing|60"} -->
                    <div style="height:var(--wp--preset--spacing--60)" aria-hidden="true" class="wp-block-spacer"></div>
                    <!-- /wp:spacer -->
                    
                    <!-- wp:heading {"textAlign":"center","level":2} -->
                    <h2 class="has-text-align-center">Try it out yourself</h2>
                    <!-- /wp:heading -->

                    <!-- wp:paragraph {"align":"center"} -->
                    <p class="has-text-align-center">A quick demo to show how the feature works.</p>
                    <!-- /wp:paragraph -->

                    <!-- wp:buttons {"align":"center"} -->
                    <div class="wp-block-buttons is-content-justification-center">
                        <!-- wp:button {"backgroundColor":"primary","textColor":"white"} -->
                        <div class="wp-block-button"><a class="wp-block-button__link has-white-color has-primary-background-color has-text-color has-background wp-element-button">Start Here</a></div>
                        <!-- /wp:button -->
                    </div>
                    <!-- /wp:buttons -->
                     
                    <!-- wp:spacer {"height":"var:preset|spacing|60"} -->
                    <div style="height:var(--wp--preset--spacing--60)" aria-hidden="true" class="wp-block-spacer"></div>
                    <!-- /wp:spacer -->
                    
                </div>
            </div>
            <!-- /wp:group -->   
        </div>
    </div>
    <!-- /wp:cover -->
</div>
<!-- /wp:group -->