<?php
/**
 * Title: Intro - Two Column Text and Image with Aligned Wide Columns
 * Slug: lyrielle/lyr-intro-text-image
 * Categories: lyrielle-patterns
 * Description: A two-column layout with text on one side and an image on the other, aligned wide.
 * Viewport Width: 1200
 */
?>
<!-- wp:columns {"align":"wide","style":{"spacing":{"columnGap":"4rem"}}} -->
<div class="wp-block-columns alignwide">
    <!-- wp:column -->
    <div class="wp-block-column">
        <!-- wp:heading {"level":1} -->
        <h1>Your Heading Here</h1>
        <!-- /wp:heading -->
        <!-- wp:paragraph -->
        <p>Here is the content for your two-column layout. You can replace this text with your own content to fit the layout.</p>
        <!-- /wp:paragraph -->

        <!-- wp:buttons {"align":"center"} -->
        <div class="wp-block-buttons is-content-justification-center">
            <!-- wp:button {"backgroundColor":"primary"} -->
            <div class="wp-block-button"><a class="wp-block-button__link has-primary-background-color has-background wp-element-button">Read More</a></div>
            <!-- /wp:button -->
        </div>
        <!-- /wp:buttons -->
    </div>
    <!-- /wp:column -->

    <!-- wp:column -->
    <div class="wp-block-column">
        <!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() . '/assets/images/default-block-image.jpg' ); ?>","dimRatio":50,"minHeight":400,"focalPoint":{"x":0.5,"y":0.5},"contentPosition":"center center"} -->
        <div class="wp-block-cover" style="min-height:400px">
            <span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span>
            <img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/default-block-image.jpg' ); ?>" style="object-position:50% 50%" data-object-fit="cover" data-object-position="50% 50%" />
            <div class="wp-block-cover__inner-container">
                <!-- wp:heading {"textAlign":"center","level":2,"textColor":"white"} -->
                <h2 class="has-text-align-center has-white-color">Overlay Text on Image</h2>
                <!-- /wp:heading -->
            </div>
        </div>
        <!-- /wp:cover -->
    </div>
    <!-- /wp:column -->
</div>
<!-- /wp:columns -->