<?php
/**
 * Title: Intro - Cover
 * Slug: lyrielle/lyr-intro-cover
 * Categories: lyrielle-patterns
 * Block Types: core/cover
 * Description: A hero section with a background image, heading, and a call-to-action button.
 * Viewport Width: 1200
 */
?>
<!-- wp:group {"align":"full","className":"custom-intro-cover-block","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull custom-intro-cover-block">
    <!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() . '/assets/images/default-block-image.jpg' ); ?>","dimRatio":50,"isUserOverlayColor":false,"focalPoint":{"x":0.5,"y":0.5},"contentPosition":"center center","layout":{"type":"constrained"}} -->
    <div class="wp-block-cover">
        <span aria-hidden="true" class="wp-block-cover__background has-background-dim"></span>
        <img class="wp-block-cover__image-background" alt="" src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/default-block-image.jpg' ); ?>" style="object-position:50% 50%" data-object-fit="cover" data-object-position="50% 50%" />
        <div class="wp-block-cover__inner-container">
            <!-- wp:spacer {"height":"var:preset|spacing|60"} -->
            <div style="height:var(--wp--preset--spacing--60)" aria-hidden="true" class="wp-block-spacer"></div>
            <!-- /wp:spacer -->

            <!-- wp:group {"align":"wide","layout":{"type":"constrained"}} -->
            <div class="wp-block-group alignwide">
                <!-- wp:heading {"textAlign":"center","level":1,"style":{"color":{"text":"#ffffff"}},"fontSize":"x-large"} -->
                <h1 class="wp-block-heading has-text-align-center has-text-color has-x-large-font-size" style="color:#ffffff">Welcome to Lyrielle</h1>
                <!-- /wp:heading -->

                <!-- wp:paragraph {"align":"center","style":{"color":{"text":"#ffffff"}}} -->
                <p class="has-text-align-center has-text-color" style="color:#ffffff">Create beautiful websites with ease.</p>
                <!-- /wp:paragraph -->

                <!-- wp:spacer {"height":"var:preset|spacing|20"} -->
                <div style="height:var(--wp--preset--spacing--20)" aria-hidden="true" class="wp-block-spacer"></div>
                <!-- /wp:spacer -->

                <!-- wp:buttons {"align":"center"} -->
                <div class="wp-block-buttons is-content-justification-center">
                    <!-- wp:button {"backgroundColor":"primary"} -->
                    <div class="wp-block-button"><a class="wp-block-button__link has-primary-background-color has-background wp-element-button">Get Started</a></div>
                    <!-- /wp:button -->
                </div>
                <!-- /wp:buttons -->

            </div>
            <!-- /wp:group -->

            <!-- wp:spacer {"height":"var:preset|spacing|60"} -->
            <div style="height:var(--wp--preset--spacing--60)" aria-hidden="true" class="wp-block-spacer"></div>
            <!-- /wp:spacer -->
        </div>
    </div>
    <!-- /wp:cover -->
</div>
<!-- /wp:group -->