jQuery( function( $ ) {
	// Scroll to top
	$( function() {
		$( window ).scroll( function () {
			if ( $( this ).scrollTop () > 500) {
				$( '#scroll-to-top' ).fadeIn ();
			} else {
				$( '#scroll-to-top' ).fadeOut ();
			}
		});

		$( '#scroll-to-top' ).click( function () {
		$( 'html, body' ).animate( { scrollTop: 0 }, 1000 );
		});
	} );

	/**
	 * Plus/minus polyfill for numbers - WooCommerce
	 *
	 * Author: Bryce Adams
	 */
	function addQuantityButtons() {
		// Quantity buttons
		$( '.cart div.quantity:not(.buttons_added), .woocommerce-cart-form td.quantity:not(.buttons_added)' )
			.addClass( 'buttons_added' )
			.append( '<div class="vertical-buttons"><input type="button" value="+" class="plus" /><input type="button" value="-" class="minus" /></div>' );

		$( '.quantity' ).unbind( 'click' ).on( 'click', '.plus, .minus', function() {
			// Get values
			var $qty		= $( this ).closest( '.quantity' ).find( '.qty' ),
				currentVal	= parseFloat( $qty.val() ),
				max			= parseFloat( $qty.attr( 'max' ) ),
				min			= parseFloat( $qty.attr( 'min' ) ),
				step		= $qty.attr( 'step' );

			// Format values
			if ( ! currentVal || currentVal === '' || currentVal === 'NaN' ) currentVal = 0;
			if ( max === '' || max === 'NaN' ) max = '';
			if ( min === '' || min === 'NaN' ) min = 0;
			if ( step === 'any' || step === '' || step === undefined || parseFloat( step ) === 'NaN' ) step = 1;

			// Change the value
			if ( $( this ).is( '.plus' ) ) {

				if ( max && ( max == currentVal || currentVal > max ) ) {
					$qty.val( max );
				} else {
					$qty.val( currentVal + parseFloat( step ) );
				}

			} else {

				if ( min && ( min == currentVal || currentVal < min ) ) {
					$qty.val( min );
				} else if ( currentVal > 0 ) {
					$qty.val( currentVal - parseFloat( step ) );
				}
			}

			// Trigger change event
			$qty.trigger( 'change' );
		});

		$('.woocommerce-ordering .drop li a').on('click', function(e) {
			var form = $(this).closest('form');

			form.find('[name=orderby]').val($(this).parent().data('value'));
			form.submit();

			e.preventDefault();
		});

		$('.woocommerce .related > h2, .woocommerce .upsells > h2')
			.addClass('section-head').wrapInner('<span class="title" />');
	}

	$( document ).ready( addQuantityButtons );
	$( document ).ajaxComplete( addQuantityButtons );

	// Control product thumbs
	$( function() {
		if(  $( "ol" ).is( ".flex-control-thumbs" ) ) {
			$( '.product.type-product' ).addClass( 'thumbs-left' );
		}
	} );

	// Menu open handler
	$( '.header-wrap .main-navigation .menu-toggle.open' ).on( 'click', function() {
		$( '.mobile-menu' ).addClass( 'active' );
		$( 'body' ).addClass( 'mobile-menu-active' );
	} );

	$( '.header-wrap .mobile-menu-container .menu-toggle.close' ).on( 'click', function() {
		$( '.mobile-menu' ).removeClass( 'active' );
		$( 'body' ).removeClass( 'mobile-menu-active' );
	} );
		
	// Setup the mobile menu click handlers
	$( '.mobile-menu li > a' ).each( function() {
		if ( $( this ).parent().children( 'ul' ).length ) {
			$( '<span class="chevron"><i class="fa-solid fa-angle-down"></i></span>' ).insertAfter( $( this ) );
		}
	});
	$( '.mobile-menu li .chevron' ).on( 'click', function() {
		$( this ).closest( 'li' ).find( 'ul' ).first().parent().toggleClass( 'active item-active' );
		return false;
	} );

	// Set focus on the close button after the last element in the menu list
	$('#mobile-menu #primary-menu li a').last().on('focus', function() {
		// "last" focus guard got focus: set focus to the first field
		$('#mobile-open-menu-button').focus();
	});	  
});
