<?php

/**
 * Adjust comment form fields order
 *
 * @param array $fields
 */
function lyrielle_comment_form_order( $fields ) {

	// From Justin Tadlock's plugin
	if ( isset( $fields['comment'] ) ) {

		// Grab the comment field.
		$comment_field = $fields['comment'];

		// Remove the comment field from its current position.
		unset( $fields['comment'] );

		// Put the comment field at the end but before consent
		if ( ! empty( $fields['cookies'] ) ) {

			$offset = array_search( 'cookies', $fields );

			$fields = array_merge(
				array_slice( $fields, 0, $offset - 1 ),
				array( 'comment' => $comment_field ),
				array_slice( $fields, $offset )
			);
		}
		else {
			$fields['comment'] = $comment_field;
		}
	}

	return $fields;
}
