<?php

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function lyrielle_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'active-sidebar';
	}

	return $classes;

}
add_filter( 'body_class', 'lyrielle_body_classes' );
