<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Lyrielle
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class( 'lyrielle' ); ?>>
<?php wp_body_open(); // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedFunctionFound ?>
<div id="preloader" class="preloader-vissible"></div>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'lyrielle' ); ?></a>

	<header id="masthead" class="site-header"
	<?php if ( get_theme_mod( 'custom_logo' ) ) { ?> style="background-image: url( <?php echo esc_url( get_theme_mod( 'header_image' ) ); ?> )" <?php }?>
	>
		<div class="header-wrap">
			<div class="container">
				<div class="main-info">
					<div class="site-logo">
						<?php the_custom_logo(); ?>
					</div>

					<div class="site-branding">
						<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>

						<?php
						$lyrielle_description = get_bloginfo( 'description', 'display' );
						if ( $lyrielle_description || is_customize_preview() ) :
						?>

						<p class="site-description"><?php echo $lyrielle_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>

						<?php endif; ?>
					</div><!-- .site-branding -->
				</div>

				<nav id="site-navigation" class="main-navigation">
					<button type="button" id="mobile-open-menu-button" class="menu-toggle open" aria-controls="primary-menu" aria-expanded="false" aria-label="open navigation">></button>
					<?php
					wp_nav_menu(
						array(
							'theme_location' => 'menu-primary',
							'menu_id'        => 'primary-menu',
						)
					);
					?>
				</nav><!-- #site-navigation -->
			</div><!-- .container -->

			<?php get_template_part( 'template-parts/header/header-mobile-menu' ); ?>

		</div><!-- .header-wrap -->

	</header><!-- #masthead -->

	<div id="content" class="site-content">
