<?php
/**
 * Lyrielle functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Lyrielle
 */

if ( ! defined( 'LYR_THEME_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'LYR_THEME_VERSION', '1.0.5' );
}

if ( ! function_exists( 'lyrielle_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 */
	function lyrielle_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on Lyrielle, use a find and replace
		 * to change 'lyrielle' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'lyrielle', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 */
		add_theme_support( 'title-tag' );

		/**
		 * Default custom header.
		 */
		add_theme_support( 'custom-header' );

		/**
		 * Default custom backgrounds.
		 */
		add_theme_support( 'custom-background' );
		
		/**
		 * Block styles.
		 */
		add_theme_support( 'wp-block-styles' );

		/**
		 * Responsive embeds.
		 */
		add_theme_support( 'responsive-embeds' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 */
		add_theme_support( 'post-thumbnails' );

		/*
		 * Enable support for wide/full alignments on Gutenberg.
		 */
		add_theme_support( 'align-wide' );

		/*
		 * This theme uses wp_nav_menu() in one location.
		 */
		register_nav_menus(
			array(
				'menu-primary' => esc_html__( 'Primary', 'lyrielle' ),
				'menu-mobile' => esc_html__( 'Mobile Menu (Optional)', 'lyrielle' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array( 'search-form', 'comment-form', 'comment-list', 'gallery', 'caption', 'style', 'script', )
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'lyrielle_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		/*
		 *  Add theme support for selective refresh for widgets.
		 */
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'lyrielle_setup' );

/**
 * Register custom block styles.
 */
function lyrielle_register_block_styles() {
    // Register a custom block style for the core button block.
    register_block_style(
        'core/button',
        array(
            'name'  => 'outline-colorful-button',
            'label' => __( 'Outline Colorful', 'lyrielle' ),
        )
    );

	register_block_style(
        'core/button',
        array(
            'name'  => 'gradient-1-button',
            'label' => __( 'Gradient 1', 'lyrielle' ),
        )
    );

	register_block_style(
        'core/button',
        array(
            'name'  => 'gradient-2-button',
            'label' => __( 'Gradient 2', 'lyrielle' ),
        )
    );

	register_block_style(
        'core/button',
        array(
            'name'  => 'gradient-3-button',
            'label' => __( 'Gradient 3', 'lyrielle' ),
        )
    );

	register_block_style(
        'core/button',
        array(
            'name'  => 'gradient-4-button',
            'label' => __( 'Gradient 4', 'lyrielle' ),
        )
    );

	register_block_style(
        'core/button',
        array(
            'name'  => 'gradient-5-button',
            'label' => __( 'Gradient 5', 'lyrielle' ),
        )
    );

    // Register a custom block style for the image block with a shape.
    register_block_style(
        'core/image',
        array(
            'name'  => 'hexagon-image',
            'label' => __( 'Hexagon', 'lyrielle' ),
        )
    );

	register_block_style(
        'core/image',
        array(
            'name'  => 'with-shape-image',
            'label' => __( 'With Shape', 'lyrielle' ),
        )
    );
	register_block_style(
        'core/image',
        array(
            'name'  => 'hover-outline-image',
            'label' => __( 'Hover Outline', 'lyrielle' ),
        )
    );
}
add_action( 'init', 'lyrielle_register_block_styles' );

/**
 * Register Block Pattern Categories
 */
function lyrielle_register_block_pattern_categories() {
	if ( function_exists( 'register_block_pattern_category' ) ) {
		register_block_pattern_category( 'lyrielle-patterns', array( 'label' => __( 'Lyrielle Patterns', 'lyrielle' ) ) );
	}
}
add_action( 'init', 'lyrielle_register_block_pattern_categories' );

/**
 * 
 */
function lyrielle_enqueue_block_styles() {
    // Enqueue default block styles
    wp_enqueue_style( 'wp-block-library' );
}
add_action( 'wp_enqueue_scripts', 'lyrielle_enqueue_block_styles' );


/**
 * Load Jetpack compatibility file.
 */
function lyrielle_footer_widgets_init() {
	register_sidebar(
		array(
			'name' 			=> esc_html_x( 'Footer Widgets', 'Admin', 'lyrielle' ),
			'id'   			=> 'lyrielle-footer',
			'description'	=> esc_html_x( 'Add three widgets for the footer area. (Optional)', 'Admin', 'lyrielle' ),
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
			'before_widget' => '<li id="%1$s" class="widget column %2$s">',
			'after_widget'  => '</li>'
		)
	);
}
add_action( 'widgets_init', 'lyrielle_footer_widgets_init' );

/**
 * Fix skip link focus in IE11.
 *
 * This does not enqueue the script because it is tiny and because it is only for IE11,
 * thus it does not warrant having an entire dedicated blocking script being loaded.
 *
 * @link https://git.io/vWdr2
 */
function lyrielle_skip_link_focus_fix() {
	// The following is minified via `terser --compress --mangle -- assets/js/skip-link-focus-fix.js`.
	?>
	<script>
	/(trident|msie)/i.test( navigator.userAgent )&&document.getElementById&&window.addEventListener&&window.addEventListener( "hashchange", function(){ var t, e = location.hash.substring(1);/^[A-z0-9_-]+$/.test( e )&&( t=document.getElementById( e ) )&&( /^(?:a|select|input|button|textarea)$/i.test( t.tagName )||( t.tabIndex =- 1) ,t.focus() )}, !1 );
	</script>
	<?php
}
add_action( 'wp_print_footer_scripts', 'lyrielle_skip_link_focus_fix' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * @global int $content_width // phpcs:ignore WPThemeReview.CoreFunctionality.PrefixAllGlobals.NonPrefixedVariableFound
 */
function lyrielle_content_width() {
	// This variable is intended to be overruled from themes.
	// Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
	// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
	$GLOBALS['content_width'] = apply_filters( 'lyrielle_content_width', 740 );
}
add_action( 'after_setup_theme', 'lyrielle_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function lyrielle_sidebars_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'lyrielle' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'lyrielle' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'lyrielle_sidebars_widgets_init' );

/*
 * Enqueue Font Awesome 6
 */
function lyrielle_load_fontawesome() {
    wp_enqueue_style( 'lyrielle-fontawesome-free-css', 'https://use.fontawesome.com/releases/v6.5.2/css/all.css' );
}
add_action( 'wp_enqueue_scripts', 'lyrielle_load_fontawesome' );

/**
 * Font Awesome CDN Setup Webfont
 *
 * This will load Font Awesome from the Font Awesome Free or Pro CDN.
 */
if ( ! function_exists( 'lyrielle_fontawesome_cdn_webfont' ) ) {
	function lyrielle_fontawesome_cdn_webfont( $cdn_url = '', $integrity = null ) {
		$matches = [];
		$match_result = preg_match( '|/([^/]+?)\.css$|', $cdn_url, $matches );
		$resource_handle_uniqueness = ( $match_result === 1 ) ? $matches[1] : md5( $cdn_url );
		$resource_handle = "font-awesome-cdn-webfont-$resource_handle_uniqueness";

		foreach ( [ 'wp_enqueue_scripts', 'admin_enqueue_scripts', 'login_enqueue_scripts' ] as $action ) {
			add_action(
				$action,
				function () use ( $cdn_url, $resource_handle ) {
					wp_enqueue_style( $resource_handle, $cdn_url, [], null );
				}
			);
		}

		if( $integrity ) {
			add_filter(
				'style_loader_tag',
				function( $html, $handle ) use ( $resource_handle, $integrity ) {
					if ( in_array( $handle, [ $resource_handle ], true ) ) {
						return preg_replace(
							'/\/>$/',
							'integrity="' . $integrity .
							'" crossorigin="anonymous" />',
							$html,
							1
						);
					} else {
					return $html;
					}
				},
				10,
				2
			);
		}
	}
}

lyrielle_fontawesome_cdn_webfont(
	'https://use.fontawesome.com/releases/v5.15.4/css/all.css',
	'sha384-DyZ88mC6Up2uqS4h/KRgHuoeGwBcD4Ng9SiP4dIRy0EXTlnuz47vAwmeGwVChigm'
);

/**
 * Enqueue block editor and frontend styles.
 */
function lyrielle_enqueue_block_editor_assets() {
    // Check if we're in the block editor.
    wp_enqueue_style(
        'lyrielle-block-editor-styles',
        get_template_directory_uri() . '/css/editor-styles.min.css',
        array(),
        filemtime( get_template_directory() . '/css/editor-styles.min.css' )
    );
}
add_action( 'enqueue_block_editor_assets', 'lyrielle_enqueue_block_editor_assets' );

/**
 * Enqueue scripts and styles.
 */
function lyrielle_enqueue_frontend_assets() {
	// Enqueue frontend styles.
    wp_enqueue_style(
        'lyrielle-style',
        get_template_directory_uri() . '/css/style.min.css',
        array(),
        filemtime( get_template_directory() . '/css/style.min.css' )
    );

	// wp_enqueue_style( 'lyrielle-style', get_stylesheet_uri(), array() );
	wp_style_add_data( 'lyrielle-style', 'rtl', 'replace' );

	wp_enqueue_style(
        'lyrielle-google-monsterrat-fonts',
        'https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&family=Sarabun:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800&family=Marcellus&display=swap',
        array(),
        null
    );
	wp_enqueue_style( 'lyrielle-google-marcellus-fonts', 'https://fonts.googleapis.com/css2?family=Marcellus&display=swap', array(), null );

	wp_enqueue_script( 'lyrielle-main', get_template_directory_uri() . '/js/main.js', array( 'jquery' ), filemtime( get_template_directory() . '/js/main.js' ) );
	wp_enqueue_script( 'lyrielle-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '1.0.0', true );
	wp_enqueue_script( 'lyrielle-preloader', get_template_directory_uri() . '/js/preloader.js', array(), '1.0.0', true );
	wp_enqueue_script( 'lyrielle-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js' );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'lyrielle_enqueue_frontend_assets' );

/**
 * Main Theme File: Contains most theme-related functionality.
 */
require_once get_theme_file_path('inc/theme.php');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Load Widgets.
 */
require get_template_directory() . '/inc/widgets.php';

/**
 * This is temporary, not sure where.
 */
require get_template_directory() . '/inc/body_classes.php';

/**
 * Load WooCommerce compatibility file.
 */
if ( function_exists( 'is_woocommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}

/**
 * Enable auto-updates for the theme.
 */
add_filter( 'auto_update_theme', '__return_true' );
