<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Lyrielle
 */

get_header();
?>

	<main id="primary" class="site-main container">

		<?php if ( have_posts() ) : ?>

		<header class="page-header archive-header">
			<?php
				the_archive_title( '<h1 class="page-title archive-title">', '</h1>' );
				echo esc_html( the_archive_description( '<div class="archive-description">', '</div>' ) );
			?>
		</header><!-- .page-header -->

		<div class="main-wrap">
			<div class="main-content">
				<?php
				/* Start the Loop */
				while ( have_posts() ) :
					the_post();

					/*
					* Include the Post-Type-specific template for the content.
					* If you want to override this in a child theme, then include a file
					* called content-___.php (where ___ is the Post Type name) and that will be used instead.
					*/
					get_template_part( 'template-parts/content/content', 'archive' );

				endwhile;

				the_posts_navigation(
					array(
						'prev_text' => '<span class="nav-icon"><i class="fa-solid fa-angle-left"></i></i></span> <span class="nav-title">Older posts</span>',
						'next_text' => '<span class="nav-title">Newer posts</span> <span class="nav-icon"><i class="fa-solid fa-angle-right"></i></i></span>',
					)
				);

			else :

				get_template_part( 'template-parts/content/content', 'none' );

			endif;
			?>
			</div>

			<?php get_sidebar(); ?>
		</div>

	</main><!-- #main -->

<?php
get_footer();
