<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Lyrielle
 */

get_header();
?>

<section class="error-404 nothing">

	<div class="section">
		<div class="section-wrap">
			<div class="error-content">
				<h1 class="nothing"><?php esc_html_e( '404', 'lyrielle' ); ?></h2>
				<h2 class="title"><?php esc_html_e( 'Oops, This Page Could Not Be Found!', 'lyrielle' ); ?></h2>
				<p><?php esc_html_e( 'We can&rsquo;t seem to find the page you&rsquo;re looking for.', 'lyrielle' ); ?></p>
			</div>

			<div class="search-content">
				<?php get_search_form(); ?>
				<a href="<?php echo esc_url( home_url() ); ?>" class="backhome"><?php esc_html_e( 'Back To Home Page', 'lyrielle' ); ?></a></li>
			</div><!-- .search-content -->
		</div>
	</div>

</section><!-- .error-404 -->

<?php
get_footer();
